"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Summary;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _translations = require("../../../../../common/translations");
var _use_overview_summary_panel = require("../../../../hooks/use_overview_summary_panel");
var _quality_indicator = require("../../../quality_indicator");
var _panel = require("./panel");
var _context = require("../../context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const degradedDocsTooltip = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.datasetQuality.details.degradedDocsTooltip",
  defaultMessage: "The number of degraded documents \u2014documents with the {ignoredProperty} property\u2014 in your data set.",
  values: {
    ignoredProperty: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      language: "json",
      transparentBackground: true
    }, "_ignored")
  }
});
const failedDocsColumnTooltip = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.datasetQuality.failedDocsSummaryTooltip",
  defaultMessage: "The number of documents sent to failure store due to an issue during ingestion."
});

// Allow for lazy loading
// eslint-disable-next-line import/no-default-export
function Summary() {
  const {
    isFailureStoreEnabled
  } = (0, _context.useDatasetQualityDetailsContext)();
  const {
    isSummaryPanelLoading,
    totalDocsCount,
    sizeInBytes,
    isUserAllowedToSeeSizeInBytes,
    totalServicesCount,
    totalHostsCount,
    totalDegradedDocsCount,
    totalFailedDocsCount,
    quality
  } = (0, _use_overview_summary_panel.useOverviewSummaryPanel)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_panel.Panel, {
    title: _translations.overviewPanelTitleDocuments
  }, /*#__PURE__*/_react.default.createElement(_panel.PanelIndicator, {
    label: _translations.overviewPanelDocumentsIndicatorTotalCount,
    value: totalDocsCount,
    isLoading: isSummaryPanelLoading
  }), /*#__PURE__*/_react.default.createElement(_panel.PanelIndicator, {
    label: _translations.overviewPanelDocumentsIndicatorSize,
    value: sizeInBytes,
    isLoading: isSummaryPanelLoading,
    userHasPrivilege: isUserAllowedToSeeSizeInBytes
  })), /*#__PURE__*/_react.default.createElement(_panel.Panel, {
    title: _translations.overviewPanelTitleResources
  }, /*#__PURE__*/_react.default.createElement(_panel.PanelIndicator, {
    label: _translations.overviewPanelResourcesIndicatorServices,
    value: totalServicesCount,
    isLoading: isSummaryPanelLoading
  }), /*#__PURE__*/_react.default.createElement(_panel.PanelIndicator, {
    label: _translations.overviewPanelResourcesIndicatorSize,
    value: totalHostsCount,
    isLoading: isSummaryPanelLoading
  })), /*#__PURE__*/_react.default.createElement(_panel.Panel, {
    title: _translations.overviewPanelTitleDatasetQuality,
    secondaryTitle: /*#__PURE__*/_react.default.createElement(_quality_indicator.DatasetQualityIndicator, {
      isLoading: isSummaryPanelLoading,
      quality: quality,
      textSize: "xs"
    })
  }, /*#__PURE__*/_react.default.createElement(_panel.PanelIndicator, {
    label: _translations.overviewPanelDatasetQualityIndicatorDegradedDocs,
    value: totalDegradedDocsCount,
    isLoading: isSummaryPanelLoading,
    tooltip: degradedDocsTooltip
  }), isFailureStoreEnabled && /*#__PURE__*/_react.default.createElement(_panel.PanelIndicator, {
    label: _translations.overviewPanelDatasetQualityIndicatorFailedDocs,
    value: totalFailedDocsCount,
    isLoading: isSummaryPanelLoading,
    tooltip: failedDocsColumnTooltip
  })));
}
module.exports = exports.default;