"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FileUploadLiteView = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _file_clash_warning = require("./file_clash_warning");
var _file_manager = require("./file_manager");
var _file_manager2 = require("./file_manager/file_manager");
var _file_picker = require("./file_picker");
var _file_status = require("./file_status");
var _index_input = require("./index_input");
var _overall_upload_status = require("./overall_upload_status");
var _import_errors = require("./import_errors");
var _data_view_illustration = require("./data_view_illustration");
var _kibana_context = require("../application/kibana_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FileUploadLiteView = ({
  fileUpload,
  http,
  dataStart,
  setUploadResults,
  autoAddInference,
  indexSettings,
  onClose
}) => {
  const {
    services: {
      application: {
        navigateToApp
      }
    }
  } = (0, _kibana_context.useDataVisualizerKibana)();
  const [indexName, setIndexName] = (0, _react.useState)('');
  const [indexValidationStatus, setIndexValidationStatus] = (0, _react.useState)(_file_manager2.STATUS.NOT_STARTED);
  const fm = (0, _react.useMemo)(() => new _file_manager.FileManager(fileUpload, http, dataStart.dataViews, autoAddInference !== null && autoAddInference !== void 0 ? autoAddInference : null, true, indexSettings), [autoAddInference, dataStart.dataViews, fileUpload, http, indexSettings]);
  const deleteFile = (0, _react.useCallback)(i => fm.removeFile(i), [fm]);
  const filesStatus = (0, _useObservable.default)(fm.fileAnalysisStatus$, []);
  const uploadStatus = (0, _useObservable.default)(fm.uploadStatus$, fm.uploadStatus$.getValue());
  const fileClashes = (0, _react.useMemo)(() => uploadStatus.fileClashes.some(f => f.clash), [uploadStatus.fileClashes]);
  const fullFileUpload = (0, _react.useCallback)(() => navigateToApp('home', {
    path: '#/tutorial_directory/fileDataViz'
  }), [navigateToApp]);
  (0, _react.useEffect)(() => {
    return () => {
      fm.destroy();
    };
  }, [fm]);
  const uploadInProgress = uploadStatus.overallImportStatus === _file_manager2.STATUS.STARTED || uploadStatus.overallImportStatus === _file_manager2.STATUS.COMPLETED || uploadStatus.overallImportStatus === _file_manager2.STATUS.FAILED;
  const onImportClick = (0, _react.useCallback)(() => {
    fm.import(indexName).then(res => {
      if (setUploadResults && res) {
        setUploadResults(res);
      }
    });
  }, [fm, indexName, setUploadResults]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.uploadView.uploadFileTitle",
    defaultMessage: "Upload a file"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, uploadStatus.overallImportStatus === _file_manager2.STATUS.NOT_STARTED ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.uploadView.uploadFileDescription",
    defaultMessage: "Upload your file, analyze its data, and import the data into an Elasticsearch index. The data can also be automatically vectorized using semantic text."
  }), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.uploadView.uploadFileDescriptionLink",
    defaultMessage: "If you need to customize the file upload process, the full version is available {fullToolLink}.",
    values: {
      fullToolLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: fullFileUpload
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.uploadView.uploadFileDescriptionLinkText",
        defaultMessage: "here"
      }))
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_file_picker.FilePicker, {
    fileManager: fm
  })) : null, uploadStatus.overallImportStatus === _file_manager2.STATUS.NOT_STARTED ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, filesStatus.map((status, i) => /*#__PURE__*/_react.default.createElement(_file_status.FileStatus, {
    uploadStatus: uploadStatus,
    fileStatus: status,
    key: i,
    deleteFile: () => deleteFile(i),
    index: i
  })), fileClashes ? /*#__PURE__*/_react.default.createElement(_file_clash_warning.FileClashWarning, {
    uploadStatus: uploadStatus,
    filesStatus: filesStatus,
    removeClashingFiles: () => fm.removeClashingFiles()
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : null, uploadStatus.overallImportStatus === _file_manager2.STATUS.NOT_STARTED && filesStatus.length > 0 && uploadStatus.analysisOk ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_index_input.IndexInput, {
    setIndexName: setIndexName,
    setIndexValidationStatus: setIndexValidationStatus,
    fileUpload: fileUpload
  })) : null, uploadInProgress ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_data_view_illustration.DataViewIllustration, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_overall_upload_status.OverallUploadStatus, {
    uploadStatus: uploadStatus,
    filesStatus: filesStatus
  }), uploadStatus.overallImportStatus === _file_manager2.STATUS.FAILED ? /*#__PURE__*/_react.default.createElement(_import_errors.ImportErrors, {
    uploadStatus: uploadStatus
  }) : null) : null))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: onClose,
    flush: "left"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.uploadView.closeButton",
    defaultMessage: "Close"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, uploadStatus.overallImportStatus === _file_manager2.STATUS.STARTED ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose,
    disabled: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.uploadView.importingButton",
    defaultMessage: "Importing"
  })))) : null, uploadStatus.overallImportStatus === _file_manager2.STATUS.NOT_STARTED ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: indexName === '' || indexValidationStatus !== _file_manager2.STATUS.COMPLETED,
    onClick: onImportClick
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.uploadView.importButton",
    defaultMessage: "Import"
  })) : null))));
};
exports.FileUploadLiteView = FileUploadLiteView;