"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SubmittingType = exports.Footer = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
let SubmittingType = exports.SubmittingType = /*#__PURE__*/function (SubmittingType) {
  SubmittingType["savingAsAdHoc"] = "savingAsAdHoc";
  SubmittingType["persisting"] = "persisting";
  return SubmittingType;
}({});
const closeButtonLabel = _i18n.i18n.translate('indexPatternEditor.editor.flyoutCloseButtonLabel', {
  defaultMessage: 'Close'
});
const saveButtonLabel = _i18n.i18n.translate('indexPatternEditor.editor.flyoutSaveButtonLabel', {
  defaultMessage: 'Save data view to Kibana'
});
const editButtonLabel = _i18n.i18n.translate('indexPatternEditor.editor.flyoutEditButtonLabel', {
  defaultMessage: 'Save'
});
const editUnpersistedButtonLabel = _i18n.i18n.translate('indexPatternEditor.editor.flyoutEditUnpersistedButtonLabel', {
  defaultMessage: 'Continue to use without saving'
});
const exploreButtonLabel = _i18n.i18n.translate('indexPatternEditor.editor.flyoutExploreButtonLabel', {
  defaultMessage: 'Use without saving'
});
const Footer = ({
  onCancel,
  onSubmit,
  submittingType,
  submitDisabled,
  isEdit,
  allowAdHoc,
  isPersisted,
  canSave
}) => {
  const isEditingAdHoc = isEdit && !isPersisted;
  const submitPersisted = () => {
    onSubmit(false);
  };
  const submitAdHoc = () => {
    onSubmit(true);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    className: "indexPatternEditor__footer"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    flush: "left",
    onClick: onCancel,
    "data-test-subj": "closeFlyoutButton"
  }, closeButtonLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    gutterSize: "s",
    alignItems: "center",
    wrap: true
  }, allowAdHoc && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    onClick: submitAdHoc,
    "data-test-subj": "exploreIndexPatternButton",
    disabled: submitDisabled,
    isLoading: submittingType === SubmittingType.savingAsAdHoc,
    title: _i18n.i18n.translate('indexPatternEditor.editor.flyoutExploreButtonTitle', {
      defaultMessage: 'Use this data view without creating a saved object'
    })
  }, exploreButtonLabel)), (canSave || isEditingAdHoc) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    onClick: submitPersisted,
    "data-test-subj": "saveIndexPatternButton",
    fill: true,
    disabled: submitDisabled,
    isLoading: submittingType === SubmittingType.persisting || submittingType === SubmittingType.savingAsAdHoc && isEditingAdHoc
  }, isEdit ? isPersisted ? editButtonLabel : editUnpersistedButtonLabel : saveButtonLabel))))));
};
exports.Footer = Footer;