"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardRenderer = DashboardRenderer;
require("../_dashboard_container.scss");
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-utils-plugin/common");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _sharedUxButtonExitFullScreen = require("@kbn/shared-ux-button-exit-full-screen");
var _kibana_services = require("../../services/kibana_services");
var _dashboard_ = require("./dashboard_404");
var _use_dashboard_api = require("../../dashboard_api/use_dashboard_api");
var _dashboard_viewport = require("../component/viewport/dashboard_viewport");
var _load_dashboard_api = require("../../dashboard_api/load_dashboard_api");
var _use_dashboard_internal_api = require("../../dashboard_api/use_dashboard_internal_api");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function DashboardRenderer({
  savedObjectId,
  getCreationOptions,
  dashboardRedirect,
  showPlainSpinner,
  locator,
  onApiAvailable
}) {
  const dashboardViewport = (0, _react.useRef)(null);
  const dashboardContainerRef = (0, _react.useRef)(null);
  const [dashboardApi, setDashboardApi] = (0, _react.useState)();
  const [dashboardInternalApi, setDashboardInternalApi] = (0, _react.useState)();
  const [error, setError] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    /* In case the locator prop changes, we need to reassign the value in the container */
    if (dashboardApi) dashboardApi.locator = locator;
  }, [dashboardApi, locator]);
  (0, _react.useEffect)(() => {
    if (error) setError(undefined);
    if (dashboardApi) setDashboardApi(undefined);
    if (dashboardInternalApi) setDashboardInternalApi(undefined);
    let canceled = false;
    let cleanupDashboardApi;
    (0, _load_dashboard_api.loadDashboardApi)({
      getCreationOptions,
      savedObjectId
    }).then(results => {
      if (!results) return;
      if (canceled) {
        results.cleanup();
        return;
      }
      cleanupDashboardApi = results.cleanup;
      setDashboardApi(results.api);
      setDashboardInternalApi(results.internalApi);
      onApiAvailable === null || onApiAvailable === void 0 ? void 0 : onApiAvailable(results.api);
    }).catch(err => {
      if (!canceled) setError(err);
    });
    return () => {
      var _cleanupDashboardApi;
      (_cleanupDashboardApi = cleanupDashboardApi) === null || _cleanupDashboardApi === void 0 ? void 0 : _cleanupDashboardApi();
      canceled = true;
    };
    // Disabling exhaustive deps because embeddable should only be created on first render.
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [savedObjectId]);
  const viewportClasses = (0, _classnames.default)('dashboardViewport', {
    'dashboardViewport--screenshotMode': _kibana_services.screenshotModeService.isScreenshotMode()
  }, {
    'dashboardViewport--loading': !error && !dashboardApi
  });
  const loadingSpinner = showPlainSpinner ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xxl"
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingElastic, {
    size: "xxl"
  });
  const renderDashboardContents = () => {
    if (error) {
      return error instanceof _common.SavedObjectNotFound ? /*#__PURE__*/_react.default.createElement(_dashboard_.Dashboard404Page, {
        dashboardRedirect: dashboardRedirect
      }) : error.message;
    }
    return dashboardApi && dashboardInternalApi ? /*#__PURE__*/_react.default.createElement("div", {
      className: "dashboardContainer",
      ref: e => dashboardContainerRef.current = e
    }, /*#__PURE__*/_react.default.createElement(_sharedUxButtonExitFullScreen.ExitFullScreenButtonKibanaProvider, {
      coreStart: {
        chrome: _kibana_services.coreServices.chrome,
        customBranding: _kibana_services.coreServices.customBranding
      }
    }, /*#__PURE__*/_react.default.createElement(_use_dashboard_api.DashboardContext.Provider, {
      value: dashboardApi
    }, /*#__PURE__*/_react.default.createElement(_use_dashboard_internal_api.DashboardInternalContext.Provider, {
      value: dashboardInternalApi
    }, /*#__PURE__*/_react.default.createElement(_dashboard_viewport.DashboardViewport, {
      dashboardContainerRef: dashboardContainerRef
    }))))) : loadingSpinner;
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: dashboardViewport,
    className: viewportClasses
  }, (dashboardViewport === null || dashboardViewport === void 0 ? void 0 : dashboardViewport.current) && dashboardApi && /*#__PURE__*/_react.default.createElement(ParentClassController, {
    viewportRef: dashboardViewport.current,
    dashboardApi: dashboardApi
  }), renderDashboardContents());
}

/**
 * Maximizing a panel in Dashboard only works if the parent div has a certain class. This
 * small component listens to the Dashboard's expandedPanelId state and adds and removes
 * the class to whichever element renders the Dashboard.
 */
const ParentClassController = ({
  dashboardApi,
  viewportRef
}) => {
  const maximizedPanelId = (0, _presentationPublishing.useStateFromPublishingSubject)(dashboardApi.expandedPanelId$);
  (0, _react.useLayoutEffect)(() => {
    const parentDiv = viewportRef.parentElement;
    if (!parentDiv) return;
    if (maximizedPanelId) {
      parentDiv.classList.add('dshDashboardViewportWrapper');
    } else {
      parentDiv.classList.remove('dshDashboardViewportWrapper');
    }
  }, [maximizedPanelId, viewportRef.parentElement]);
  return null;
};