"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.startDashboardSearchSessionIntegration = startDashboardSearchSessionIntegration;
var _rxjs = require("rxjs");
var _public = require("@kbn/data-plugin/public");
var _kibana_services = require("../../../../services/kibana_services");
var _new_session = require("./new_session");
var _get_dashboard_capabilities = require("../../../../utils/get_dashboard_capabilities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Enables dashboard search sessions.
 */
function startDashboardSearchSessionIntegration(dashboardApi, searchSessionSettings, setSearchSessionId) {
  if (!searchSessionSettings) return;
  const {
    sessionIdUrlChangeObservable,
    getSearchSessionIdFromURL,
    removeSessionIdFromUrl,
    createSessionRestorationDataProvider
  } = searchSessionSettings;
  _kibana_services.dataService.search.session.enableStorage(createSessionRestorationDataProvider(dashboardApi), {
    isDisabled: () => (0, _get_dashboard_capabilities.getDashboardCapabilities)().storeSearchSession ? {
      disabled: false
    } : {
      disabled: true,
      reasonText: _public.noSearchSessionStorageCapabilityMessage
    }
  });

  // force refresh when the session id in the URL changes. This will also fire off the "handle search session change" below.
  const searchSessionIdChangeSubscription = sessionIdUrlChangeObservable === null || sessionIdUrlChangeObservable === void 0 ? void 0 : sessionIdUrlChangeObservable.pipe((0, _rxjs.skip)(1)).subscribe(() => dashboardApi.forceRefresh());
  const newSessionSubscription = (0, _new_session.newSession$)(dashboardApi).subscribe(() => {
    const currentSearchSessionId = dashboardApi.searchSessionId$.value;
    const updatedSearchSessionId = (_searchSessionIdFromU => {
      let searchSessionIdFromURL = getSearchSessionIdFromURL();
      if (searchSessionIdFromURL) {
        if (_kibana_services.dataService.search.session.isRestore() && _kibana_services.dataService.search.session.isCurrentSession(searchSessionIdFromURL)) {
          // we had previously been in a restored session but have now changed state so remove the session id from the URL.
          removeSessionIdFromUrl();
          searchSessionIdFromURL = undefined;
        } else {
          _kibana_services.dataService.search.session.restore(searchSessionIdFromURL);
        }
      }
      return (_searchSessionIdFromU = searchSessionIdFromURL) !== null && _searchSessionIdFromU !== void 0 ? _searchSessionIdFromU : _kibana_services.dataService.search.session.start();
    })();
    if (updatedSearchSessionId && updatedSearchSessionId !== currentSearchSessionId) {
      setSearchSessionId(updatedSearchSessionId);
    }
  });
  return () => {
    searchSessionIdChangeSubscription === null || searchSessionIdChangeSubscription === void 0 ? void 0 : searchSessionIdChangeSubscription.unsubscribe();
    newSessionSubscription.unsubscribe();
  };
}