"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardSaveModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/saved-objects-plugin/public");
var _kibana_services = require("../../../../services/kibana_services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * TODO: Portable Dashboard followup, use redux for the state.
 * https://github.com/elastic/kibana/issues/147490
 */

const DashboardSaveModal = ({
  customModalTitle,
  description,
  onClose,
  onSave,
  showCopyOnSave,
  showStoreTimeOnSave = true,
  tags,
  title,
  timeRestore
}) => {
  const [selectedTags, setSelectedTags] = _react.default.useState(tags !== null && tags !== void 0 ? tags : []);
  const [persistSelectedTimeInterval, setPersistSelectedTimeInterval] = _react.default.useState(timeRestore);
  const saveDashboard = _react.default.useCallback(({
    newTitle,
    newDescription,
    newCopyOnSave,
    isTitleDuplicateConfirmed,
    onTitleDuplicate
  }) => {
    onSave({
      newTitle,
      newDescription,
      newCopyOnSave,
      newTimeRestore: persistSelectedTimeInterval,
      isTitleDuplicateConfirmed,
      onTitleDuplicate,
      newTags: selectedTags
    });
  }, [onSave, persistSelectedTimeInterval, selectedTags]);
  const renderDashboardSaveOptions = (0, _react.useCallback)(() => {
    const savedObjectsTaggingApi = _kibana_services.savedObjectsTaggingService === null || _kibana_services.savedObjectsTaggingService === void 0 ? void 0 : _kibana_services.savedObjectsTaggingService.getTaggingApi();
    const tagSelector = savedObjectsTaggingApi ? /*#__PURE__*/_react.default.createElement(savedObjectsTaggingApi.ui.components.SavedObjectSaveModalTagSelector, {
      initialSelection: selectedTags,
      onTagsSelected: selectedTagIds => {
        setSelectedTags(selectedTagIds);
      },
      markOptional: true
    }) : undefined;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, tagSelector, showStoreTimeOnSave ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      gutterSize: "s",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      "data-test-subj": "storeTimeWithDashboard",
      checked: persistSelectedTimeInterval,
      onChange: event => {
        setPersistSelectedTimeInterval(event.target.checked);
      },
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "dashboard.topNav.saveModal.storeTimeWithDashboardFormRowLabel",
        defaultMessage: "Store time with dashboard"
      })
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "dashboard.topNav.saveModal.storeTimeWithDashboardFormRowHelpText",
        defaultMessage: "This changes the time filter to the currently selected time each time this dashboard is loaded."
      }),
      position: "top"
    })))) : null);
  }, [persistSelectedTimeInterval, selectedTags, showStoreTimeOnSave]);
  return /*#__PURE__*/_react.default.createElement(_public.SavedObjectSaveModal, {
    onSave: saveDashboard,
    onClose: onClose,
    title: title,
    description: description,
    showDescription: true,
    showCopyOnSave: showCopyOnSave,
    initialCopyOnSave: showCopyOnSave,
    objectType: _i18n.i18n.translate('dashboard.topNav.saveModal.objectType', {
      defaultMessage: 'dashboard'
    }),
    customModalTitle: customModalTitle,
    options: renderDashboardSaveOptions()
  });
};
exports.DashboardSaveModal = DashboardSaveModal;