"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardGrid = void 0;
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _coreRenderingBrowser = require("@kbn/core-rendering-browser");
var _gridLayout = require("@kbn/grid-layout");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _constants = require("../../../../common/content_management/constants");
var _are_panel_layouts_equal = require("../../../dashboard_api/are_panel_layouts_equal");
var _use_dashboard_api = require("../../../dashboard_api/use_dashboard_api");
var _constants2 = require("./constants");
var _dashboard_grid_item = require("./dashboard_grid_item");
var _use_layout_styles = require("./use_layout_styles");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DashboardGrid = ({
  dashboardContainerRef
}) => {
  const dashboardApi = (0, _use_dashboard_api.useDashboardApi)();
  const layoutStyles = (0, _use_layout_styles.useLayoutStyles)();
  const panelRefs = (0, _react.useRef)({});
  const [expandedPanelId, panels, useMargins, viewMode] = (0, _presentationPublishing.useBatchedPublishingSubjects)(dashboardApi.expandedPanelId$, dashboardApi.panels$, dashboardApi.settings.useMargins$, dashboardApi.viewMode$);
  const appFixedViewport = (0, _coreRenderingBrowser.useAppFixedViewport)();
  const currentLayout = (0, _react.useMemo)(() => {
    const singleRow = {
      title: '',
      // we only support a single section currently, and it does not have a title
      isCollapsed: false,
      panels: {}
    };
    Object.keys(panels).forEach(panelId => {
      const gridData = panels[panelId].gridData;
      singleRow.panels[panelId] = {
        id: panelId,
        row: gridData.y,
        column: gridData.x,
        width: gridData.w,
        height: gridData.h
      };
    });
    return [singleRow];
  }, [panels]);
  const onLayoutChange = (0, _react.useCallback)(newLayout => {
    if (viewMode !== 'edit') return;
    const currentPanels = dashboardApi.panels$.getValue();
    const updatedPanels = Object.values(newLayout[0].panels).reduce((updatedPanelsAcc, panelLayout) => {
      updatedPanelsAcc[panelLayout.id] = {
        ...currentPanels[panelLayout.id],
        gridData: {
          i: panelLayout.id,
          y: panelLayout.row,
          x: panelLayout.column,
          w: panelLayout.width,
          h: panelLayout.height
        }
      };
      return updatedPanelsAcc;
    }, {});
    if (!(0, _are_panel_layouts_equal.arePanelLayoutsEqual)(currentPanels, updatedPanels)) {
      dashboardApi.setPanels(updatedPanels);
    }
  }, [dashboardApi, viewMode]);
  const renderPanelContents = (0, _react.useCallback)((id, setDragHandles) => {
    const currentPanels = dashboardApi.panels$.getValue();
    if (!currentPanels[id]) return;
    if (!panelRefs.current[id]) {
      panelRefs.current[id] = /*#__PURE__*/_react.default.createRef();
    }
    const type = currentPanels[id].type;
    return /*#__PURE__*/_react.default.createElement(_dashboard_grid_item.DashboardGridItem, {
      ref: panelRefs.current[id],
      "data-grid": currentPanels[id].gridData,
      key: id,
      id: id,
      type: type,
      setDragHandles: setDragHandles,
      appFixedViewport: appFixedViewport,
      dashboardContainerRef: dashboardContainerRef
    });
  }, [appFixedViewport, dashboardApi, dashboardContainerRef]);
  const memoizedgridLayout = (0, _react.useMemo)(() => {
    // memoizing this component reduces the number of times it gets re-rendered to a minimum
    return /*#__PURE__*/_react.default.createElement(_gridLayout.GridLayout, {
      css: layoutStyles,
      layout: currentLayout,
      gridSettings: {
        gutterSize: useMargins ? _constants2.DASHBOARD_MARGIN_SIZE : 0,
        rowHeight: _constants2.DASHBOARD_GRID_HEIGHT,
        columnCount: _constants.DASHBOARD_GRID_COLUMN_COUNT
      },
      renderPanelContents: renderPanelContents,
      onLayoutChange: onLayoutChange,
      expandedPanelId: expandedPanelId,
      accessMode: viewMode === 'edit' ? 'EDIT' : 'VIEW'
    });
  }, [layoutStyles, currentLayout, useMargins, renderPanelContents, onLayoutChange, expandedPanelId, viewMode]);
  const classes = (0, _classnames.default)({
    'dshLayout-withoutMargins': !useMargins,
    'dshLayout--viewing': viewMode === 'view',
    'dshLayout--editing': viewMode !== 'view',
    'dshLayout-isMaximizedPanel': expandedPanelId !== undefined
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    className: classes
  }, memoizedgridLayout);
};
exports.DashboardGrid = DashboardGrid;