"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.startSyncingExpandedPanelState = exports.loadAndRemoveDashboardState = exports.isPanelVersionTooOld = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _rxjs = require("rxjs");
var _satisfies = _interopRequireDefault(require("semver/functions/satisfies"));
var _common = require("@kbn/kibana-utils-plugin/common");
var _common2 = require("../../../common");
var _urls = require("../../utils/urls");
var _load_dashboard_state = require("../../services/dashboard_content_management_service/lib/load_dashboard_state");
var _kibana_services = require("../../services/kibana_services");
var _dashboard_app_strings = require("../_dashboard_app_strings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const panelIsLegacy = panel => {
  return panel.embeddableConfig !== undefined;
};

/**
 * We no longer support loading panels from a version older than 7.3 in the URL.
 * @returns whether or not there is a panel in the URL state saved with a version before 7.3
 */
const isPanelVersionTooOld = panels => {
  for (const panel of panels) {
    if (!panel.gridData || !(panel.panelConfig || panel.embeddableConfig) || panel.version && (0, _satisfies.default)(panel.version, '<7.3')) return true;
  }
  return false;
};
exports.isPanelVersionTooOld = isPanelVersionTooOld;
function getPanelsMap(appStateInUrl) {
  if (!appStateInUrl.panels) {
    return undefined;
  }
  if (appStateInUrl.panels.length === 0) {
    return {};
  }
  if (isPanelVersionTooOld(appStateInUrl.panels)) {
    _kibana_services.coreServices.notifications.toasts.addWarning((0, _dashboard_app_strings.getPanelTooOldErrorString)());
    return undefined;
  }

  // convert legacy embeddableConfig keys to panelConfig
  const panels = appStateInUrl.panels.map(panel => {
    if (panelIsLegacy(panel)) {
      const {
        embeddableConfig,
        ...rest
      } = panel;
      return {
        ...rest,
        panelConfig: embeddableConfig
      };
    }
    return panel;
  });
  return (0, _common2.convertPanelsArrayToPanelMap)(panels);
}

/**
 * Loads any dashboard state from the URL, and removes the state from the URL.
 */
const loadAndRemoveDashboardState = kbnUrlStateStorage => {
  const rawAppStateInUrl = kbnUrlStateStorage.get(_urls.DASHBOARD_STATE_STORAGE_KEY);
  if (!rawAppStateInUrl) return {};
  const panelsMap = getPanelsMap(rawAppStateInUrl);
  const nextUrl = (0, _common.replaceUrlHashQuery)(window.location.href, hashQuery => {
    delete hashQuery[_urls.DASHBOARD_STATE_STORAGE_KEY];
    return hashQuery;
  });
  kbnUrlStateStorage.kbnUrlControls.update(nextUrl, true);
  const partialState = {
    ..._lodash.default.omit(rawAppStateInUrl, ['panels', 'query']),
    ...(panelsMap ? {
      panels: panelsMap
    } : {}),
    ...(rawAppStateInUrl.query ? {
      query: (0, _load_dashboard_state.migrateLegacyQuery)(rawAppStateInUrl.query)
    } : {})
  };
  return partialState;
};
exports.loadAndRemoveDashboardState = loadAndRemoveDashboardState;
const startSyncingExpandedPanelState = ({
  dashboardApi,
  history
}) => {
  const expandedPanelSubscription = dashboardApi === null || dashboardApi === void 0 ? void 0 : dashboardApi.expandedPanelId$
  // skip the first value because we don't want to trigger a history.replace on initial load
  .pipe((0, _rxjs.skip)(1)).subscribe(expandedPanelId => {
    history.replace({
      ...history.location,
      pathname: `${(0, _urls.createDashboardEditUrl)(dashboardApi.savedObjectId$.value)}${Boolean(expandedPanelId) ? `/${expandedPanelId}` : ''}`
    });
  });
  const stopWatchingExpandedPanel = () => expandedPanelSubscription.unsubscribe();
  return {
    stopWatchingExpandedPanel
  };
};
exports.startSyncingExpandedPanelState = startSyncingExpandedPanelState;