"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardEditingToolbar = DashboardEditingToolbar;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _sharedUxButtonToolbar = require("@kbn/shared-ux-button-toolbar");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _use_dashboard_api = require("../../dashboard_api/use_dashboard_api");
var _kibana_services = require("../../services/kibana_services");
var _dashboard_app_strings = require("../_dashboard_app_strings");
var _controls_toolbar_button = require("./controls_toolbar_button");
var _add_panel_button = require("./add_panel_button/components/add_panel_button");
var _api = require("../../dashboard_container/embeddable/api");
var _navigate_to_vis_editor = require("./add_panel_button/navigate_to_vis_editor");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function DashboardEditingToolbar({
  isDisabled
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const dashboardApi = (0, _use_dashboard_api.useDashboardApi)();
  const navigateToDefaultEditor = (0, _react2.useCallback)(() => {
    const lensAlias = _kibana_services.visualizationsService.getAliases().find(({
      name
    }) => name === 'lens');
    (0, _navigate_to_vis_editor.navigateToVisEditor)(dashboardApi, lensAlias);
  }, [dashboardApi]);
  const controlGroupApi = (0, _presentationPublishing.useStateFromPublishingSubject)(dashboardApi.controlGroupApi$);
  const extraButtons = [/*#__PURE__*/_react2.default.createElement(_add_panel_button.AddPanelButton, {
    isDisabled: isDisabled
  }), /*#__PURE__*/_react2.default.createElement(_sharedUxButtonToolbar.AddFromLibraryButton, {
    onClick: () => (0, _api.addFromLibrary)(dashboardApi),
    size: "s",
    "data-test-subj": "dashboardAddFromLibraryButton",
    isDisabled: isDisabled
  }), /*#__PURE__*/_react2.default.createElement(_controls_toolbar_button.ControlsToolbarButton, {
    isDisabled: isDisabled,
    controlGroupApi: controlGroupApi
  })];
  return /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
        padding: 0 ${euiTheme.size.s} ${euiTheme.size.s} ${euiTheme.size.s};
      `
  }, /*#__PURE__*/_react2.default.createElement(_sharedUxButtonToolbar.Toolbar, null, {
    primaryButton: /*#__PURE__*/_react2.default.createElement(_sharedUxButtonToolbar.ToolbarButton, {
      type: "primary",
      isDisabled: isDisabled,
      iconType: "lensApp",
      size: "s",
      onClick: navigateToDefaultEditor,
      label: (0, _dashboard_app_strings.getCreateVisualizationButtonTitle)(),
      "data-test-subj": "dashboardAddNewPanelButton"
    }),
    extraButtons
  }));
}