"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeViewModeManager = initializeViewModeManager;
var _rxjs = require("rxjs");
var _dashboard_backup_service = require("../services/dashboard_backup_service");
var _get_dashboard_capabilities = require("../utils/get_dashboard_capabilities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function initializeViewModeManager(incomingEmbeddable, savedObjectResult) {
  const dashboardBackupService = (0, _dashboard_backup_service.getDashboardBackupService)();
  function getInitialViewMode() {
    if (savedObjectResult !== null && savedObjectResult !== void 0 && savedObjectResult.managed || !(0, _get_dashboard_capabilities.getDashboardCapabilities)().showWriteControls) {
      return 'view';
    }
    if (incomingEmbeddable || savedObjectResult !== null && savedObjectResult !== void 0 && savedObjectResult.newDashboardCreated || dashboardBackupService.dashboardHasUnsavedEdits(savedObjectResult === null || savedObjectResult === void 0 ? void 0 : savedObjectResult.dashboardId)) return 'edit';
    return dashboardBackupService.getViewMode();
  }
  const viewMode$ = new _rxjs.BehaviorSubject(getInitialViewMode());
  function setViewMode(viewMode) {
    // block the Dashboard from entering edit mode if this Dashboard is managed.
    if (savedObjectResult !== null && savedObjectResult !== void 0 && savedObjectResult.managed && (viewMode === null || viewMode === void 0 ? void 0 : viewMode.toLowerCase()) === 'edit') {
      return;
    }
    viewMode$.next(viewMode);
  }
  return {
    api: {
      viewMode$,
      setViewMode
    },
    comparators: {
      viewMode: [viewMode$, setViewMode,
      // When compared view mode is always considered unequal so that it gets backed up.
      // view mode unsaved changes do not show unsaved badge
      () => false]
    }
  };
}