"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OPEN_FLYOUT_ADD_DRILLDOWN = exports.FlyoutCreateDrilldownAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/embeddable-enhanced-plugin/public");
var _public2 = require("@kbn/embeddable-plugin/public");
var _i18n = require("@kbn/i18n");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _presentationContainers = require("@kbn/presentation-containers");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public3 = require("@kbn/ui-actions-plugin/public");
var _react = _interopRequireDefault(require("react"));
var _drilldown_shared = require("../drilldown_shared");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OPEN_FLYOUT_ADD_DRILLDOWN = exports.OPEN_FLYOUT_ADD_DRILLDOWN = 'OPEN_FLYOUT_ADD_DRILLDOWN';
const isApiCompatible = api => (0, _public.apiHasDynamicActions)(api) && (0, _presentationPublishing.apiHasParentApi)(api) && (0, _presentationPublishing.apiCanAccessViewMode)(api) && (0, _presentationPublishing.apiHasSupportedTriggers)(api);
class FlyoutCreateDrilldownAction {
  constructor(params) {
    (0, _defineProperty2.default)(this, "type", OPEN_FLYOUT_ADD_DRILLDOWN);
    (0, _defineProperty2.default)(this, "id", OPEN_FLYOUT_ADD_DRILLDOWN);
    (0, _defineProperty2.default)(this, "order", 12);
    (0, _defineProperty2.default)(this, "grouping", [_drilldown_shared.DRILLDOWN_ACTION_GROUP]);
    this.params = params;
  }
  getDisplayName() {
    return _i18n.i18n.translate('xpack.dashboard.FlyoutCreateDrilldownAction.displayName', {
      defaultMessage: 'Create drilldown'
    });
  }
  getIconType() {
    return 'plusInCircle';
  }
  async isCompatible({
    embeddable
  }) {
    if (!isApiCompatible(embeddable)) return false;
    if ((0, _presentationPublishing.getInheritedViewMode)(embeddable) !== 'edit' || !(0, _presentationPublishing.apiIsOfType)(embeddable.parentApi, 'dashboard')) return false;
    const supportedTriggers = [_public2.CONTEXT_MENU_TRIGGER, ...embeddable.supportedTriggers()];

    /**
     * Check if there is an intersection between all registered drilldowns possible triggers that they could be attached to
     * and triggers that current embeddable supports
     */
    const allPossibleTriggers = this.params.start().plugins.uiActionsEnhanced.getActionFactories().map(factory => factory.isCompatibleLicense() ? factory.supportedTriggers() : []).reduce((res, next) => res.concat(next), []);
    return (0, _drilldown_shared.ensureNestedTriggers)(supportedTriggers).some(trigger => allPossibleTriggers.includes(trigger));
  }
  async execute({
    embeddable
  }) {
    if (!isApiCompatible(embeddable)) throw new _public3.IncompatibleActionError();
    const {
      core,
      plugins
    } = this.params.start();
    const templates = (0, _drilldown_shared.createDrilldownTemplatesFromSiblings)(embeddable);
    const overlayTracker = (0, _presentationContainers.tracksOverlays)(embeddable.parentApi) ? embeddable.parentApi : undefined;
    const close = () => {
      if (overlayTracker) overlayTracker.clearOverlays();
      handle.close();
    };
    const triggers = [...(0, _drilldown_shared.ensureNestedTriggers)(embeddable.supportedTriggers()), _public2.CONTEXT_MENU_TRIGGER];
    const handle = core.overlays.openFlyout((0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(plugins.uiActionsEnhanced.DrilldownManager, {
      closeAfterCreate: true,
      initialRoute: '/new',
      dynamicActionManager: embeddable.enhancements.dynamicActions,
      triggers: triggers,
      placeContext: {
        embeddable
      },
      templates: templates,
      onClose: close
    }), core), {
      maxWidth: _drilldown_shared.DRILLDOWN_MAX_WIDTH,
      ownFocus: true,
      'data-test-subj': 'createDrilldownFlyout',
      onClose: () => {
        close();
      }
    });
    overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.openOverlay(handle);
  }
}
exports.FlyoutCreateDrilldownAction = FlyoutCreateDrilldownAction;