"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.catchRetryableSearchPhaseExecutionException = exports.catchRetryableEsClientErrors = void 0;
var Either = _interopRequireWildcard(require("fp-ts/lib/Either"));
var _coreElasticsearchServerInternal = require("@kbn/core-elasticsearch-server-internal");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const catchRetryableEsClientErrors = e => {
  if ((0, _coreElasticsearchServerInternal.isRetryableEsClientError)(e)) {
    return Either.left({
      type: 'retryable_es_client_error',
      message: e === null || e === void 0 ? void 0 : e.message,
      error: e
    });
  } else {
    throw e;
  }
};
exports.catchRetryableEsClientErrors = catchRetryableEsClientErrors;
const catchRetryableSearchPhaseExecutionException = e => {
  var _e$body, _e$body$error;
  if ((e === null || e === void 0 ? void 0 : (_e$body = e.body) === null || _e$body === void 0 ? void 0 : (_e$body$error = _e$body.error) === null || _e$body$error === void 0 ? void 0 : _e$body$error.type) === 'search_phase_execution_exception') {
    return Either.left({
      type: 'retryable_es_client_error',
      message: e === null || e === void 0 ? void 0 : e.message,
      error: e
    });
  } else {
    throw e;
  }
};
exports.catchRetryableSearchPhaseExecutionException = catchRetryableSearchPhaseExecutionException;