"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.coreFeatureFlagsMock = void 0;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createFeatureFlagsInternalSetup = () => {
  return {
    ...createFeatureFlagsSetup(),
    getOverrides: jest.fn().mockReturnValue({})
  };
};
const createFeatureFlagsSetup = () => {
  return {
    setProvider: jest.fn(),
    appendContext: jest.fn()
  };
};
const createFeatureFlagsStart = () => {
  return {
    appendContext: jest.fn(),
    getBooleanValue: jest.fn().mockImplementation(async (_, fallback) => fallback),
    getNumberValue: jest.fn().mockImplementation(async (_, fallback) => fallback),
    getStringValue: jest.fn().mockImplementation(async (_, fallback) => fallback),
    getBooleanValue$: jest.fn().mockImplementation((_, fallback) => (0, _rxjs.of)(fallback)),
    getStringValue$: jest.fn().mockImplementation((_, fallback) => (0, _rxjs.of)(fallback)),
    getNumberValue$: jest.fn().mockImplementation((_, fallback) => (0, _rxjs.of)(fallback))
  };
};
const createRequestHandlerContext = () => {
  return {
    getBooleanValue: jest.fn().mockImplementation(async (_, fallback) => fallback),
    getNumberValue: jest.fn().mockImplementation(async (_, fallback) => fallback),
    getStringValue: jest.fn().mockImplementation(async (_, fallback) => fallback)
  };
};
const createFeatureFlagsServiceMock = () => {
  return {
    setup: jest.fn().mockImplementation(createFeatureFlagsInternalSetup),
    start: jest.fn().mockImplementation(createFeatureFlagsStart),
    stop: jest.fn().mockImplementation(Promise.resolve)
  };
};

/**
 * Mocks for the Feature Flags service (browser-side)
 */
const coreFeatureFlagsMock = exports.coreFeatureFlagsMock = {
  /**
   * Mocks the entire feature flags service
   */
  create: createFeatureFlagsServiceMock,
  /**
   * Mocks the core-internal setup contract
   */
  createInternalSetup: createFeatureFlagsInternalSetup,
  /**
   * Mocks the setup contract
   */
  createSetup: createFeatureFlagsSetup,
  /**
   * Mocks the start contract
   */
  createStart: createFeatureFlagsStart,
  /**
   * Mocks the request handler context contract
   */
  createRequestHandlerContext
};