"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerMarkAsResolvedRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _deprecations = require("../deprecations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const registerMarkAsResolvedRoute = (router, {
  coreUsageData
}) => {
  router.post({
    path: '/mark_as_resolved',
    options: {
      access: 'internal'
    },
    validate: {
      body: _configSchema.schema.object({
        domainId: _configSchema.schema.string(),
        routePath: _configSchema.schema.string(),
        routeMethod: _configSchema.schema.oneOf([_configSchema.schema.literal('post'), _configSchema.schema.literal('put'), _configSchema.schema.literal('delete'), _configSchema.schema.literal('patch'), _configSchema.schema.literal('get'), _configSchema.schema.literal('options')]),
        routeVersion: _configSchema.schema.maybe(_configSchema.schema.string()),
        incrementBy: _configSchema.schema.number()
      })
    }
  }, async (_, req, res) => {
    const usageClient = coreUsageData.getClient();
    const {
      routeMethod,
      routePath,
      routeVersion,
      incrementBy
    } = req.body;
    const counterName = (0, _deprecations.buildApiDeprecationId)({
      routeMethod,
      routePath,
      routeVersion
    });
    await usageClient.incrementDeprecatedApi(counterName, {
      resolved: true,
      incrementBy
    });
    return res.ok();
  });
};
exports.registerMarkAsResolvedRoute = registerMarkAsResolvedRoute;