"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppStatus = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * Accessibility status of an application.
 *
 * @public
 */
let AppStatus = exports.AppStatus = /*#__PURE__*/function (AppStatus) {
  AppStatus[AppStatus["accessible"] = 0] = "accessible";
  AppStatus[AppStatus["inaccessible"] = 1] = "inaccessible";
  return AppStatus;
}({});
/**
 * App navigation menu options
 * @public
 */
/**
 * Updater for applications.
 * see {@link ApplicationSetup}
 * @public
 */
/**
 * Defines the list of fields that can be updated via an {@link AppUpdater}.
 * @public
 */
/**
 * @public
 */
/**
 * Public information about a registered app's {@link AppDeepLink | deepLinks}
 *
 * @public
 */
/** The places in the UI where a deepLink can be shown */
/**
 * Input type for registering secondary in-app locations for an application.
 *
 * Deep links must include at least one of `path` or `deepLinks`. A deep link that does not have a `path`
 * represents a topological level in the application's hierarchy, but does not have a destination URL that is
 * user-accessible.
 * @public
 */
/**
 * Public information about a registered {@link App | application}
 *
 * @public
 */