"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Server = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _elasticApmNode = _interopRequireDefault(require("elastic-apm-node"));
var _rxjs = require("rxjs");
var _coreBaseServerInternal = require("@kbn/core-base-server-internal");
var _config = require("@kbn/config");
var _coreDocLinksServerInternal = require("@kbn/core-doc-links-server-internal");
var _coreLoggingServerInternal = require("@kbn/core-logging-server-internal");
var _coreConfigServerInternal = require("@kbn/core-config-server-internal");
var _coreNodeServerInternal = require("@kbn/core-node-server-internal");
var _coreAnalyticsServerInternal = require("@kbn/core-analytics-server-internal");
var _coreEnvironmentServerInternal = require("@kbn/core-environment-server-internal");
var _coreExecutionContextServerInternal = require("@kbn/core-execution-context-server-internal");
var _coreFeatureFlagsServerInternal = require("@kbn/core-feature-flags-server-internal");
var _corePrebootServerInternal = require("@kbn/core-preboot-server-internal");
var _coreHttpContextServerInternal = require("@kbn/core-http-context-server-internal");
var _coreHttpServerInternal = require("@kbn/core-http-server-internal");
var _coreElasticsearchServerInternal = require("@kbn/core-elasticsearch-server-internal");
var _coreMetricsServerInternal = require("@kbn/core-metrics-server-internal");
var _coreCapabilitiesServerInternal = require("@kbn/core-capabilities-server-internal");
var _coreSavedObjectsServerInternal = require("@kbn/core-saved-objects-server-internal");
var _coreI18nServerInternal = require("@kbn/core-i18n-server-internal");
var _coreDeprecationsServerInternal = require("@kbn/core-deprecations-server-internal");
var _coreUsageDataServerInternal = require("@kbn/core-usage-data-server-internal");
var _coreStatusServerInternal = require("@kbn/core-status-server-internal");
var _coreUiSettingsServerInternal = require("@kbn/core-ui-settings-server-internal");
var _coreCustomBrandingServerInternal = require("@kbn/core-custom-branding-server-internal");
var _coreUserSettingsServerInternal = require("@kbn/core-user-settings-server-internal");
var _coreHttpRequestHandlerContextServerInternal = require("@kbn/core-http-request-handler-context-server-internal");
var _coreRenderingServerInternal = require("@kbn/core-rendering-server-internal");
var _coreHttpRateLimiterInternal = require("@kbn/core-http-rate-limiter-internal");
var _coreHttpResourcesServerInternal = require("@kbn/core-http-resources-server-internal");
var _corePluginsServerInternal = require("@kbn/core-plugins-server-internal");
var _coreAppsServerInternal = require("@kbn/core-apps-server-internal");
var _coreSecurityServerInternal = require("@kbn/core-security-server-internal");
var _coreUserProfileServerInternal = require("@kbn/core-user-profile-server-internal");
var _register_service_config = require("./register_service_config");
var _constants = require("./constants");
var _core_config = require("./core_config");
var _events = require("./events");
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const coreId = Symbol('core');

/** @internal */
var _pluginsInitialized = /*#__PURE__*/new WeakMap();
class Server {
  constructor(rawConfigProvider, env, loggingSystem) {
    (0, _defineProperty2.default)(this, "configService", void 0);
    (0, _defineProperty2.default)(this, "analytics", void 0);
    (0, _defineProperty2.default)(this, "capabilities", void 0);
    (0, _defineProperty2.default)(this, "context", void 0);
    (0, _defineProperty2.default)(this, "elasticsearch", void 0);
    (0, _defineProperty2.default)(this, "featureFlags", void 0);
    (0, _defineProperty2.default)(this, "http", void 0);
    (0, _defineProperty2.default)(this, "rendering", void 0);
    (0, _defineProperty2.default)(this, "log", void 0);
    (0, _defineProperty2.default)(this, "plugins", void 0);
    (0, _defineProperty2.default)(this, "savedObjects", void 0);
    (0, _defineProperty2.default)(this, "uiSettings", void 0);
    (0, _defineProperty2.default)(this, "environment", void 0);
    (0, _defineProperty2.default)(this, "node", void 0);
    (0, _defineProperty2.default)(this, "metrics", void 0);
    (0, _defineProperty2.default)(this, "httpRateLimiter", void 0);
    (0, _defineProperty2.default)(this, "httpResources", void 0);
    (0, _defineProperty2.default)(this, "status", void 0);
    (0, _defineProperty2.default)(this, "logging", void 0);
    (0, _defineProperty2.default)(this, "coreApp", void 0);
    (0, _defineProperty2.default)(this, "coreUsageData", void 0);
    (0, _defineProperty2.default)(this, "i18n", void 0);
    (0, _defineProperty2.default)(this, "deprecations", void 0);
    (0, _defineProperty2.default)(this, "executionContext", void 0);
    (0, _defineProperty2.default)(this, "prebootService", void 0);
    (0, _defineProperty2.default)(this, "docLinks", void 0);
    (0, _defineProperty2.default)(this, "customBranding", void 0);
    (0, _defineProperty2.default)(this, "userSettingsService", void 0);
    (0, _defineProperty2.default)(this, "security", void 0);
    (0, _defineProperty2.default)(this, "userProfile", void 0);
    (0, _defineProperty2.default)(this, "savedObjectsStartPromise", void 0);
    (0, _defineProperty2.default)(this, "resolveSavedObjectsStartPromise", void 0);
    _classPrivateFieldInitSpec(this, _pluginsInitialized, void 0);
    (0, _defineProperty2.default)(this, "coreStart", void 0);
    (0, _defineProperty2.default)(this, "discoveredPlugins", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "nodeRoles", void 0);
    (0, _defineProperty2.default)(this, "uptimePerStep", {});
    this.env = env;
    this.loggingSystem = loggingSystem;
    const constructorStartUptime = performance.now();
    this.logger = this.loggingSystem.asLoggerFactory();
    this.log = this.logger.get('server');
    this.configService = new _config.ConfigService(rawConfigProvider, env, this.logger);
    const core = {
      coreId,
      configService: this.configService,
      env,
      logger: this.logger
    };
    this.analytics = new _coreAnalyticsServerInternal.AnalyticsService(core);
    this.context = new _coreHttpContextServerInternal.ContextService(core);
    this.featureFlags = new _coreFeatureFlagsServerInternal.FeatureFlagsService(core);
    this.http = new _coreHttpServerInternal.HttpService(core);
    this.rendering = new _coreRenderingServerInternal.RenderingService(core);
    this.plugins = new _corePluginsServerInternal.PluginsService(core);
    this.elasticsearch = new _coreElasticsearchServerInternal.ElasticsearchService(core);
    this.savedObjects = new _coreSavedObjectsServerInternal.SavedObjectsService(core);
    this.uiSettings = new _coreUiSettingsServerInternal.UiSettingsService(core);
    this.capabilities = new _coreCapabilitiesServerInternal.CapabilitiesService(core);
    this.environment = new _coreEnvironmentServerInternal.EnvironmentService(core);
    this.node = new _coreNodeServerInternal.NodeService(core);
    this.metrics = new _coreMetricsServerInternal.MetricsService(core);
    this.status = new _coreStatusServerInternal.StatusService(core);
    this.coreApp = new _coreAppsServerInternal.CoreAppsService(core);
    this.httpRateLimiter = new _coreHttpRateLimiterInternal.HttpRateLimiterService();
    this.httpResources = new _coreHttpResourcesServerInternal.HttpResourcesService(core);
    this.logging = new _coreLoggingServerInternal.LoggingService(core);
    this.coreUsageData = new _coreUsageDataServerInternal.CoreUsageDataService(core);
    this.i18n = new _coreI18nServerInternal.I18nService(core);
    this.deprecations = new _coreDeprecationsServerInternal.DeprecationsService(core);
    this.executionContext = new _coreExecutionContextServerInternal.ExecutionContextService(core);
    this.prebootService = new _corePrebootServerInternal.PrebootService(core);
    this.docLinks = new _coreDocLinksServerInternal.DocLinksService(core);
    this.customBranding = new _coreCustomBrandingServerInternal.CustomBrandingService(core);
    this.userSettingsService = new _coreUserSettingsServerInternal.UserSettingsService(core);
    this.security = new _coreSecurityServerInternal.SecurityService(core);
    this.userProfile = new _coreUserProfileServerInternal.UserProfileService(core);
    this.savedObjectsStartPromise = new Promise(resolve => {
      this.resolveSavedObjectsStartPromise = resolve;
    });
    this.uptimePerStep.constructor = {
      start: constructorStartUptime,
      end: performance.now()
    };
  }
  async preboot() {
    this.log.debug('prebooting server');
    const config = await (0, _rxjs.firstValueFrom)(this.configService.atPath(_core_config.coreConfig.path));
    const {
      disablePreboot
    } = config.lifecycle;
    if (disablePreboot) {
      this.log.info('preboot phase is disabled - skipping');
    }
    const prebootStartUptime = performance.now();
    const prebootTransaction = _elasticApmNode.default.startTransaction('server-preboot', 'kibana-platform');

    // service required for plugin discovery
    const analyticsPreboot = this.analytics.preboot();
    const environmentPreboot = await this.environment.preboot({
      analytics: analyticsPreboot
    });
    const nodePreboot = await this.node.preboot({
      loggingSystem: this.loggingSystem
    });
    this.nodeRoles = nodePreboot.roles;

    // Discover any plugins before continuing. This allows other systems to utilize the plugin dependency graph.
    this.discoveredPlugins = await this.plugins.discover({
      environment: environmentPreboot,
      node: nodePreboot
    });
    if (!disablePreboot) {
      // Immediately terminate in case of invalid configuration. This needs to be done after plugin discovery. We also
      // silent deprecation warnings until `setup` stage where we'll validate config once again.
      await (0, _coreConfigServerInternal.ensureValidConfiguration)(this.configService, {
        logDeprecations: false
      });
    }

    // services we need to preboot even when preboot is disabled
    const uiSettingsPreboot = await this.uiSettings.preboot();
    const loggingPreboot = this.logging.preboot({
      loggingSystem: this.loggingSystem
    });
    let corePreboot;
    if (!disablePreboot) {
      const {
        uiPlugins,
        pluginTree,
        pluginPaths
      } = this.discoveredPlugins.preboot;
      const contextServicePreboot = this.context.preboot({
        pluginDependencies: new Map([...pluginTree.asOpaqueIds])
      });
      const httpPreboot = await this.http.preboot({
        context: contextServicePreboot
      });

      // setup i18n prior to any other service, to have translations ready
      const i18nPreboot = await this.i18n.preboot({
        http: httpPreboot,
        pluginPaths
      });
      this.capabilities.preboot({
        http: httpPreboot
      });
      const elasticsearchServicePreboot = await this.elasticsearch.preboot();
      await this.status.preboot({
        http: httpPreboot
      });
      const renderingPreboot = await this.rendering.preboot({
        http: httpPreboot,
        uiPlugins,
        i18n: i18nPreboot
      });
      const httpResourcesPreboot = this.httpResources.preboot({
        http: httpPreboot,
        rendering: renderingPreboot
      });
      corePreboot = {
        analytics: analyticsPreboot,
        context: contextServicePreboot,
        elasticsearch: elasticsearchServicePreboot,
        http: httpPreboot,
        uiSettings: uiSettingsPreboot,
        httpResources: httpResourcesPreboot,
        logging: loggingPreboot,
        preboot: this.prebootService.preboot()
      };
      await this.plugins.preboot(corePreboot);
      httpPreboot.registerRouteHandlerContext(coreId, 'core', () => {
        return new _coreHttpRequestHandlerContextServerInternal.PrebootCoreRouteHandlerContext(corePreboot);
      });
      this.coreApp.preboot(corePreboot, uiPlugins);
    }
    prebootTransaction.end();
    this.uptimePerStep.preboot = {
      start: prebootStartUptime,
      end: performance.now()
    };
    return corePreboot;
  }
  async setup() {
    this.log.debug('setting up server');
    const setupStartUptime = performance.now();
    const setupTransaction = _elasticApmNode.default.startTransaction('server-setup', 'kibana-platform');
    const analyticsSetup = this.analytics.setup();
    (0, _events.registerRootEvents)(analyticsSetup);
    const environmentSetup = this.environment.setup();

    // Configuration could have changed after preboot.
    await this.ensureValidConfiguration();
    const {
      uiPlugins,
      pluginPaths,
      pluginTree
    } = this.discoveredPlugins.standard;
    const contextServiceSetup = this.context.setup({
      pluginDependencies: new Map([...pluginTree.asOpaqueIds])
    });
    const executionContextSetup = this.executionContext.setup();
    const docLinksSetup = this.docLinks.setup();
    const securitySetup = this.security.setup();
    const userProfileSetup = this.userProfile.setup();
    const httpSetup = await this.http.setup({
      context: contextServiceSetup,
      executionContext: executionContextSetup
    });

    // setup i18n prior to any other service, to have translations ready
    const i18nServiceSetup = await this.i18n.setup({
      http: httpSetup,
      pluginPaths
    });
    const capabilitiesSetup = this.capabilities.setup({
      http: httpSetup
    });
    const elasticsearchServiceSetup = await this.elasticsearch.setup({
      analytics: analyticsSetup,
      http: httpSetup,
      executionContext: executionContextSetup
    });
    const metricsSetup = await this.metrics.setup({
      http: httpSetup,
      elasticsearchService: elasticsearchServiceSetup
    });
    const coreUsageDataSetup = this.coreUsageData.setup({
      http: httpSetup,
      metrics: metricsSetup,
      savedObjectsStartPromise: this.savedObjectsStartPromise,
      changedDeprecatedConfigPath$: this.configService.getDeprecatedConfigPath$()
    });
    const loggingSetup = this.logging.setup();
    const deprecationsSetup = await this.deprecations.setup({
      http: httpSetup,
      coreUsageData: coreUsageDataSetup,
      logging: loggingSetup,
      docLinks: docLinksSetup
    });
    const savedObjectsSetup = await this.savedObjects.setup({
      http: httpSetup,
      elasticsearch: elasticsearchServiceSetup,
      deprecations: deprecationsSetup,
      coreUsageData: coreUsageDataSetup,
      docLinks: docLinksSetup
    });
    const uiSettingsSetup = await this.uiSettings.setup({
      http: httpSetup,
      savedObjects: savedObjectsSetup
    });
    const statusSetup = await this.status.setup({
      analytics: analyticsSetup,
      elasticsearch: elasticsearchServiceSetup,
      pluginDependencies: pluginTree.asNames,
      savedObjects: savedObjectsSetup,
      environment: environmentSetup,
      http: httpSetup,
      metrics: metricsSetup,
      coreUsageData: coreUsageDataSetup
    });
    const customBrandingSetup = this.customBranding.setup();
    const userSettingsServiceSetup = this.userSettingsService.setup();
    const featureFlagsSetup = this.featureFlags.setup();
    const renderingSetup = await this.rendering.setup({
      elasticsearch: elasticsearchServiceSetup,
      featureFlags: featureFlagsSetup,
      http: httpSetup,
      status: statusSetup,
      uiPlugins,
      customBranding: customBrandingSetup,
      userSettings: userSettingsServiceSetup,
      i18n: i18nServiceSetup
    });
    this.httpRateLimiter.setup({
      http: httpSetup,
      metrics: metricsSetup
    });
    const httpResourcesSetup = this.httpResources.setup({
      http: httpSetup,
      rendering: renderingSetup
    });
    const coreSetup = {
      analytics: analyticsSetup,
      capabilities: capabilitiesSetup,
      context: contextServiceSetup,
      customBranding: customBrandingSetup,
      docLinks: docLinksSetup,
      elasticsearch: elasticsearchServiceSetup,
      environment: environmentSetup,
      executionContext: executionContextSetup,
      featureFlags: featureFlagsSetup,
      http: httpSetup,
      i18n: i18nServiceSetup,
      savedObjects: savedObjectsSetup,
      status: statusSetup,
      uiSettings: uiSettingsSetup,
      rendering: renderingSetup,
      httpResources: httpResourcesSetup,
      logging: loggingSetup,
      metrics: metricsSetup,
      deprecations: deprecationsSetup,
      coreUsageData: coreUsageDataSetup,
      userSettings: userSettingsServiceSetup,
      security: securitySetup,
      userProfile: userProfileSetup
    };
    const pluginsSetup = await this.plugins.setup(coreSetup);
    _classPrivateFieldSet(_pluginsInitialized, this, pluginsSetup.initialized);
    this.registerCoreContext(coreSetup);
    await this.coreApp.setup(coreSetup, uiPlugins);
    setupTransaction.end();
    this.uptimePerStep.setup = {
      start: setupStartUptime,
      end: performance.now()
    };
    return coreSetup;
  }
  async start() {
    var _this$nodeRoles;
    this.log.debug('starting server');
    const startStartUptime = performance.now();
    const startTransaction = _elasticApmNode.default.startTransaction('server-start', 'kibana-platform');
    const analyticsStart = this.analytics.start();
    const securityStart = this.security.start();
    const userProfileStart = this.userProfile.start();
    this.userSettingsService.start({
      userProfile: userProfileStart
    });
    const executionContextStart = this.executionContext.start();
    const docLinkStart = this.docLinks.start();
    const elasticsearchStart = await this.elasticsearch.start();
    this.uptimePerStep.elasticsearch = {
      waitTime: elasticsearchStart.metrics.elasticsearchWaitTime
    };
    const deprecationsStart = this.deprecations.start();
    const soStartSpan = startTransaction.startSpan('saved_objects.migration', 'migration');
    const savedObjectsStart = await this.savedObjects.start({
      elasticsearch: elasticsearchStart,
      pluginsInitialized: _classPrivateFieldGet(_pluginsInitialized, this),
      docLinks: docLinkStart,
      node: await this.node.start()
    });
    this.uptimePerStep.savedObjects = {
      migrationTime: savedObjectsStart.metrics.migrationDuration
    };
    await this.resolveSavedObjectsStartPromise(savedObjectsStart);
    soStartSpan === null || soStartSpan === void 0 ? void 0 : soStartSpan.end();
    if (((_this$nodeRoles = this.nodeRoles) === null || _this$nodeRoles === void 0 ? void 0 : _this$nodeRoles.migrator) === true) {
      startTransaction.end();
      this.log.info('Detected migrator node role; shutting down Kibana...');
      throw new _coreBaseServerInternal.CriticalError('Migrations completed, shutting down Kibana', _constants.MIGRATION_EXCEPTION_CODE, 0);
    }
    const capabilitiesStart = this.capabilities.start();
    const uiSettingsStart = await this.uiSettings.start();
    const customBrandingStart = this.customBranding.start();
    const metricsStart = await this.metrics.start();
    const httpStart = this.http.getStartContract();
    const coreUsageDataStart = this.coreUsageData.start({
      elasticsearch: elasticsearchStart,
      savedObjects: savedObjectsStart,
      exposedConfigsToUsage: this.plugins.getExposedPluginConfigsToUsage()
    });
    const featureFlagsStart = this.featureFlags.start();
    this.httpRateLimiter.start();
    this.status.start();
    this.coreStart = {
      analytics: analyticsStart,
      capabilities: capabilitiesStart,
      customBranding: customBrandingStart,
      docLinks: docLinkStart,
      elasticsearch: elasticsearchStart,
      executionContext: executionContextStart,
      featureFlags: featureFlagsStart,
      http: httpStart,
      metrics: metricsStart,
      savedObjects: savedObjectsStart,
      uiSettings: uiSettingsStart,
      coreUsageData: coreUsageDataStart,
      deprecations: deprecationsStart,
      security: securityStart,
      userProfile: userProfileStart
    };
    this.coreApp.start(this.coreStart);
    await this.plugins.start(this.coreStart);
    await this.http.start();
    startTransaction.end();
    this.uptimePerStep.start = {
      start: startStartUptime,
      end: performance.now()
    };
    (0, _events.reportKibanaStartedEvent)({
      uptimeSteps: this.uptimePerStep,
      analytics: analyticsStart
    });
    return this.coreStart;
  }
  async stop() {
    this.log.debug('stopping server');
    this.coreApp.stop();
    this.httpRateLimiter.stop();
    await this.analytics.stop();
    await this.http.stop(); // HTTP server has to stop before savedObjects and ES clients are closed to be able to gracefully attempt to resolve any pending requests
    await this.plugins.stop();
    await this.savedObjects.stop();
    await this.elasticsearch.stop();
    await this.uiSettings.stop();
    await this.rendering.stop();
    await this.metrics.stop();
    await this.status.stop();
    await this.logging.stop();
    await this.customBranding.stop();
    await this.featureFlags.stop();
    this.node.stop();
    this.deprecations.stop();
    this.security.stop();
    this.userProfile.stop();
  }
  async ensureValidConfiguration() {
    try {
      await (0, _coreConfigServerInternal.ensureValidConfiguration)(this.configService);
    } catch (validationError) {
      if (this.env.packageInfo.buildFlavor !== 'serverless') {
        throw validationError;
      }
      // When running on serverless, we may allow unknown keys, but stripping them from the final config object.
      this.configService.setGlobalStripUnknownKeys(true);
      await (0, _coreConfigServerInternal.ensureValidConfiguration)(this.configService, {
        logDeprecations: true,
        stripUnknownKeys: true
      });
      this.log.get('config-validation').error(`Strict config validation failed! Extra unknown keys removed in Serverless-compatible mode. Original error: ${validationError}`);
    }
  }
  registerCoreContext(coreSetup) {
    coreSetup.http.registerRouteHandlerContext(coreId, 'core', (context, req) => {
      return new _coreHttpRequestHandlerContextServerInternal.CoreRouteHandlerContext(this.coreStart, req);
    });
  }
  setupCoreConfig() {
    (0, _register_service_config.registerServiceConfig)(this.configService);
  }
}
exports.Server = Server;