"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOptionsListControlFactory = void 0;
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _esQuery = require("@kbn/es-query");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _common = require("../../../../common");
var _options_list = require("../../../../common/options_list");
var _initialize_data_control = require("../initialize_data_control");
var _options_list_control = require("./components/options_list_control");
var _options_list_editor_options = require("./components/options_list_editor_options");
var _constants = require("./constants");
var _fetch_and_validate = require("./fetch_and_validate");
var _options_list_context_provider = require("./options_list_context_provider");
var _options_list_control_selections = require("./options_list_control_selections");
var _options_list_strings = require("./options_list_strings");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getOptionsListControlFactory = () => {
  return {
    type: _common.OPTIONS_LIST_CONTROL,
    order: 3,
    // should always be first, since this is the most popular control
    getIconType: () => 'editorChecklist',
    getDisplayName: _options_list_strings.OptionsListStrings.control.getDisplayName,
    isFieldCompatible: field => {
      return !field.spec.scripted && field.aggregatable && ['string', 'boolean', 'ip', 'date', 'number'].includes(field.type);
    },
    CustomOptionsComponent: _options_list_editor_options.OptionsListEditorOptions,
    buildControl: async (initialState, buildApi, uuid, controlGroupApi) => {
      var _initialState$searchT, _initialState$sort, _initialState$selecte;
      /** Serializable state - i.e. the state that is saved with the control */
      const searchTechnique$ = new _rxjs.BehaviorSubject((_initialState$searchT = initialState.searchTechnique) !== null && _initialState$searchT !== void 0 ? _initialState$searchT : _constants.DEFAULT_SEARCH_TECHNIQUE);
      const runPastTimeout$ = new _rxjs.BehaviorSubject(initialState.runPastTimeout);
      const singleSelect$ = new _rxjs.BehaviorSubject(initialState.singleSelect);
      const sort$ = new _rxjs.BehaviorSubject((_initialState$sort = initialState.sort) !== null && _initialState$sort !== void 0 ? _initialState$sort : _constants.OPTIONS_LIST_DEFAULT_SORT);

      /** Creation options state - cannot currently be changed after creation, but need subjects for comparators */
      const placeholder$ = new _rxjs.BehaviorSubject(initialState.placeholder);
      const hideActionBar$ = new _rxjs.BehaviorSubject(initialState.hideActionBar);
      const hideExclude$ = new _rxjs.BehaviorSubject(initialState.hideExclude);
      const hideExists$ = new _rxjs.BehaviorSubject(initialState.hideExists);
      const hideSort$ = new _rxjs.BehaviorSubject(initialState.hideSort);

      /** Runtime / component state - none of this is serialized */
      const searchString$ = new _rxjs.BehaviorSubject('');
      const searchStringValid$ = new _rxjs.BehaviorSubject(true);
      const requestSize$ = new _rxjs.BehaviorSubject(_constants.MIN_OPTIONS_LIST_REQUEST_SIZE);
      const dataLoading$ = new _rxjs.BehaviorSubject(undefined);
      const availableOptions$ = new _rxjs.BehaviorSubject(undefined);
      const invalidSelections$ = new _rxjs.BehaviorSubject(new Set());
      const totalCardinality$ = new _rxjs.BehaviorSubject(0);
      const dataControl = (0, _initialize_data_control.initializeDataControl)(uuid, _common.OPTIONS_LIST_CONTROL, 'optionsListDataView', initialState, {
        searchTechnique: searchTechnique$,
        singleSelect: singleSelect$,
        runPastTimeout: runPastTimeout$
      }, controlGroupApi);
      const selections = (0, _options_list_control_selections.initializeOptionsListSelections)(initialState, dataControl.setters.onSelectionChange);
      const stateManager = {
        ...dataControl.stateManager,
        exclude: selections.exclude$,
        existsSelected: selections.existsSelected$,
        searchTechnique: searchTechnique$,
        selectedOptions: selections.selectedOptions$,
        singleSelect: singleSelect$,
        sort: sort$,
        searchString: searchString$,
        searchStringValid: searchStringValid$,
        runPastTimeout: runPastTimeout$,
        requestSize: requestSize$
      };

      /** Handle loading state; since suggestion fetching and validation are tied, only need one loading subject */
      const loadingSuggestions$ = new _rxjs.BehaviorSubject(false);
      const dataLoadingSubscription = (0, _rxjs.combineLatest)([loadingSuggestions$, dataControl.api.dataLoading$]).pipe((0, _rxjs.debounceTime)(100),
      // debounce set loading so that it doesn't flash as the user types
      (0, _rxjs.map)(values => values.some(value => value))).subscribe(isLoading => {
        dataLoading$.next(isLoading);
      });

      /** Debounce the search string changes to reduce the number of fetch requests */
      const debouncedSearchString = stateManager.searchString.pipe((0, _rxjs.debounceTime)(100));

      /** Validate the search string as the user types */
      const validSearchStringSubscription = (0, _rxjs.combineLatest)([debouncedSearchString, dataControl.api.field$, searchTechnique$]).subscribe(([newSearchString, field, searchTechnique]) => {
        searchStringValid$.next((0, _options_list.isValidSearch)({
          searchString: newSearchString,
          fieldType: field === null || field === void 0 ? void 0 : field.type,
          searchTechnique
        }));
      });

      /** Clear state when the field changes */
      const fieldChangedSubscription = (0, _rxjs.combineLatest)([dataControl.stateManager.fieldName, dataControl.stateManager.dataViewId]).pipe((0, _rxjs.skip)(1) // skip first, since this represents initialization
      ).subscribe(() => {
        searchString$.next('');
        selections.setSelectedOptions(undefined);
        selections.setExistsSelected(false);
        selections.setExclude(false);
        requestSize$.next(_constants.MIN_OPTIONS_LIST_REQUEST_SIZE);
        sort$.next(_constants.OPTIONS_LIST_DEFAULT_SORT);
      });

      /** Fetch the suggestions and perform validation */
      const loadMoreSubject = new _rxjs.Subject();
      const fetchSubscription = (0, _fetch_and_validate.fetchAndValidate$)({
        api: {
          ...dataControl.api,
          loadMoreSubject,
          loadingSuggestions$,
          debouncedSearchString,
          parentApi: controlGroupApi
        },
        stateManager,
        controlFetch$: onReload => controlGroupApi.controlFetch$(uuid, onReload)
      }).subscribe(result => {
        var _successResponse$tota, _successResponse$inva;
        // if there was an error during fetch, set blocking error and return early
        if (Object.hasOwn(result, 'error')) {
          dataControl.api.setBlockingError(result.error);
          return;
        } else if (dataControl.api.blockingError$.getValue()) {
          // otherwise,  if there was a previous error, clear it
          dataControl.api.setBlockingError(undefined);
        }

        // fetch was successful so set all attributes from result
        const successResponse = result;
        availableOptions$.next(successResponse.suggestions);
        totalCardinality$.next((_successResponse$tota = successResponse.totalCardinality) !== null && _successResponse$tota !== void 0 ? _successResponse$tota : 0);
        invalidSelections$.next(new Set((_successResponse$inva = successResponse.invalidSelections) !== null && _successResponse$inva !== void 0 ? _successResponse$inva : []));

        // reset the request size back to the minimum (if it's not already)
        if (stateManager.requestSize.getValue() !== _constants.MIN_OPTIONS_LIST_REQUEST_SIZE) {
          stateManager.requestSize.next(_constants.MIN_OPTIONS_LIST_REQUEST_SIZE);
        }
      });

      /** Remove all other selections if this control becomes a single select */
      const singleSelectSubscription = singleSelect$.pipe((0, _rxjs.filter)(singleSelect => Boolean(singleSelect))).subscribe(() => {
        var _selections$selectedO;
        const currentSelections = (_selections$selectedO = selections.selectedOptions$.getValue()) !== null && _selections$selectedO !== void 0 ? _selections$selectedO : [];
        if (currentSelections.length > 1) selections.setSelectedOptions([currentSelections[0]]);
      });
      const hasSelections$ = new _rxjs.BehaviorSubject(Boolean(((_initialState$selecte = initialState.selectedOptions) === null || _initialState$selecte === void 0 ? void 0 : _initialState$selecte.length) || initialState.existsSelected));
      const hasSelectionsSubscription = (0, _rxjs.combineLatest)([selections.selectedOptions$, selections.existsSelected$]).pipe((0, _rxjs.map)(([selectedOptions, existsSelected]) => {
        return Boolean((selectedOptions === null || selectedOptions === void 0 ? void 0 : selectedOptions.length) || existsSelected);
      }), (0, _rxjs.distinctUntilChanged)()).subscribe(hasSelections => {
        hasSelections$.next(hasSelections);
      });
      /** Output filters when selections change */
      const outputFilterSubscription = (0, _rxjs.combineLatest)([dataControl.api.dataViews$, dataControl.stateManager.fieldName, selections.selectedOptions$, selections.existsSelected$, selections.exclude$]).pipe((0, _rxjs.debounceTime)(0)).subscribe(([dataViews, fieldName, selectedOptions, existsSelected, exclude]) => {
        const dataView = dataViews === null || dataViews === void 0 ? void 0 : dataViews[0];
        const field = dataView && fieldName ? dataView.getFieldByName(fieldName) : undefined;
        let newFilter;
        if (dataView && field) {
          if (existsSelected) {
            newFilter = (0, _esQuery.buildExistsFilter)(field, dataView);
          } else if (selectedOptions && selectedOptions.length > 0) {
            newFilter = selectedOptions.length === 1 ? (0, _esQuery.buildPhraseFilter)(field, selectedOptions[0], dataView) : (0, _esQuery.buildPhrasesFilter)(field, selectedOptions, dataView);
          }
        }
        if (newFilter) {
          newFilter.meta.key = field === null || field === void 0 ? void 0 : field.name;
          if (exclude) newFilter.meta.negate = true;
        }
        dataControl.setters.setOutputFilter(newFilter);
      });
      const api = buildApi({
        ...dataControl.api,
        dataLoading$,
        getTypeDisplayName: _options_list_strings.OptionsListStrings.control.getDisplayName,
        serializeState: () => {
          const {
            rawState: dataControlState,
            references
          } = dataControl.serialize();
          return {
            rawState: {
              ...dataControlState,
              searchTechnique: searchTechnique$.getValue(),
              runPastTimeout: runPastTimeout$.getValue(),
              singleSelect: singleSelect$.getValue(),
              selectedOptions: selections.selectedOptions$.getValue(),
              sort: sort$.getValue(),
              existsSelected: selections.existsSelected$.getValue(),
              exclude: selections.exclude$.getValue(),
              // serialize state that cannot be changed to keep it consistent
              placeholder: placeholder$.getValue(),
              hideActionBar: hideActionBar$.getValue(),
              hideExclude: hideExclude$.getValue(),
              hideExists: hideExists$.getValue(),
              hideSort: hideSort$.getValue()
            },
            references // does not have any references other than those provided by the data control serializer
          };
        },
        clearSelections: () => {
          var _selections$selectedO2;
          if ((_selections$selectedO2 = selections.selectedOptions$.getValue()) !== null && _selections$selectedO2 !== void 0 && _selections$selectedO2.length) selections.setSelectedOptions([]);
          if (selections.existsSelected$.getValue()) selections.setExistsSelected(false);
          if (invalidSelections$.getValue().size) invalidSelections$.next(new Set([]));
        },
        hasSelections$: hasSelections$
      }, {
        ...dataControl.comparators,
        ...selections.comparators,
        runPastTimeout: [runPastTimeout$, runPast => runPastTimeout$.next(runPast)],
        searchTechnique: [searchTechnique$, technique => searchTechnique$.next(technique), (a, b) => (a !== null && a !== void 0 ? a : _constants.DEFAULT_SEARCH_TECHNIQUE) === (b !== null && b !== void 0 ? b : _constants.DEFAULT_SEARCH_TECHNIQUE)],
        singleSelect: [singleSelect$, selected => singleSelect$.next(selected)],
        sort: [sort$, sort => sort$.next(sort), (a, b) => (0, _fastDeepEqual.default)(a !== null && a !== void 0 ? a : _constants.OPTIONS_LIST_DEFAULT_SORT, b !== null && b !== void 0 ? b : _constants.OPTIONS_LIST_DEFAULT_SORT)],
        /** This state cannot currently be changed after the control is created */
        placeholder: [placeholder$, placeholder => placeholder$.next(placeholder)],
        hideActionBar: [hideActionBar$, hideActionBar => hideActionBar$.next(hideActionBar)],
        hideExclude: [hideExclude$, hideExclude => hideExclude$.next(hideExclude)],
        hideExists: [hideExists$, hideExists => hideExists$.next(hideExists)],
        hideSort: [hideSort$, hideSort => hideSort$.next(hideSort)]
      });
      const componentApi = {
        ...api,
        loadMoreSubject,
        totalCardinality$,
        availableOptions$,
        invalidSelections$,
        setExclude: selections.setExclude,
        deselectOption: key => {
          var _selections$selectedO3, _selections$selectedO4;
          const field = api.field$.getValue();
          if (!key || !field) {
            api.setBlockingError(new Error(_options_list_strings.OptionsListStrings.control.getInvalidSelectionMessage()));
            return;
          }
          const keyAsType = (0, _options_list.getSelectionAsFieldType)(field, key);

          // delete from selections
          const selectedOptions = (_selections$selectedO3 = selections.selectedOptions$.getValue()) !== null && _selections$selectedO3 !== void 0 ? _selections$selectedO3 : [];
          const itemIndex = ((_selections$selectedO4 = selections.selectedOptions$.getValue()) !== null && _selections$selectedO4 !== void 0 ? _selections$selectedO4 : []).indexOf(keyAsType);
          if (itemIndex !== -1) {
            const newSelections = [...selectedOptions];
            newSelections.splice(itemIndex, 1);
            selections.setSelectedOptions(newSelections);
          }
          // delete from invalid selections
          const currentInvalid = invalidSelections$.getValue();
          if (currentInvalid.has(keyAsType)) {
            currentInvalid.delete(keyAsType);
            invalidSelections$.next(new Set(currentInvalid));
          }
        },
        makeSelection: (key, showOnlySelected) => {
          var _selections$selectedO5;
          const field = api.field$.getValue();
          if (!key || !field) {
            api.setBlockingError(new Error(_options_list_strings.OptionsListStrings.control.getInvalidSelectionMessage()));
            return;
          }
          const existsSelected = Boolean(selections.existsSelected$.getValue());
          const selectedOptions = (_selections$selectedO5 = selections.selectedOptions$.getValue()) !== null && _selections$selectedO5 !== void 0 ? _selections$selectedO5 : [];
          const singleSelect = singleSelect$.getValue();

          // the order of these checks matters, so be careful if rearranging them
          const keyAsType = (0, _options_list.getSelectionAsFieldType)(field, key);
          if (key === 'exists-option') {
            // if selecting exists, then deselect everything else
            selections.setExistsSelected(!existsSelected);
            if (!existsSelected) {
              selections.setSelectedOptions([]);
              invalidSelections$.next(new Set([]));
            }
          } else if (showOnlySelected || selectedOptions.includes(keyAsType)) {
            componentApi.deselectOption(key);
          } else if (singleSelect) {
            // replace selection
            selections.setSelectedOptions([keyAsType]);
            if (existsSelected) selections.setExistsSelected(false);
          } else {
            // select option
            if (existsSelected) selections.setExistsSelected(false);
            selections.setSelectedOptions(selectedOptions ? [...selectedOptions, keyAsType] : [keyAsType]);
          }
        }
      };
      if (selections.hasInitialSelections) {
        await dataControl.api.untilFiltersReady();
      }
      return {
        api,
        Component: ({
          className: controlPanelClassName
        }) => {
          (0, _react.useEffect)(() => {
            return () => {
              // on unmount, clean up all subscriptions
              dataLoadingSubscription.unsubscribe();
              fetchSubscription.unsubscribe();
              fieldChangedSubscription.unsubscribe();
              outputFilterSubscription.unsubscribe();
              singleSelectSubscription.unsubscribe();
              validSearchStringSubscription.unsubscribe();
              hasSelectionsSubscription.unsubscribe();
            };
          }, []);

          /** Get display settings - if these are ever made editable, should be part of stateManager instead */
          const [placeholder, hideActionBar, hideExclude, hideExists, hideSort] = (0, _presentationPublishing.useBatchedPublishingSubjects)(placeholder$, hideActionBar$, hideExclude$, hideExists$, hideSort$);
          return /*#__PURE__*/_react.default.createElement(_options_list_context_provider.OptionsListControlContext.Provider, {
            value: {
              stateManager,
              api: componentApi,
              displaySettings: {
                placeholder,
                hideActionBar,
                hideExclude,
                hideExists,
                hideSort
              }
            }
          }, /*#__PURE__*/_react.default.createElement(_options_list_control.OptionsListControl, {
            controlPanelClassName: controlPanelClassName
          }));
        }
      };
    }
  };
};
exports.getOptionsListControlFactory = getOptionsListControlFactory;