"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeControlGroupUnsavedChanges = initializeControlGroupUnsavedChanges;
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _presentationContainers = require("@kbn/presentation-containers");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _publishes_async_filters = require("../controls/data_controls/publishes_async_filters");
var _init_controls_manager = require("./init_controls_manager");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function initializeControlGroupUnsavedChanges(applySelections, children$, comparators, snapshotControlsRuntimeState, resetControlsUnsavedChanges, parentApi, lastSavedRuntimeState) {
  const controlGroupUnsavedChanges = (0, _presentationContainers.initializeUnsavedChanges)({
    autoApplySelections: lastSavedRuntimeState.autoApplySelections,
    chainingSystem: lastSavedRuntimeState.chainingSystem,
    controlsInOrder: (0, _init_controls_manager.getControlsInOrder)(lastSavedRuntimeState.initialChildControlState),
    ignoreParentSettings: lastSavedRuntimeState.ignoreParentSettings,
    labelPosition: lastSavedRuntimeState.labelPosition
  }, parentApi, comparators);
  return {
    api: {
      unsavedChanges$: (0, _rxjs.combineLatest)([controlGroupUnsavedChanges.api.unsavedChanges$, (0, _presentationContainers.childrenUnsavedChanges$)(children$)]).pipe((0, _rxjs.map)(([unsavedControlGroupState, unsavedControlsState]) => {
        const unsavedChanges = unsavedControlGroupState ? (0, _lodash.omit)(unsavedControlGroupState, 'controlsInOrder') : {};
        if (unsavedControlsState || unsavedControlGroupState !== null && unsavedControlGroupState !== void 0 && unsavedControlGroupState.controlsInOrder) {
          unsavedChanges.initialChildControlState = snapshotControlsRuntimeState();
        }
        return Object.keys(unsavedChanges).length ? unsavedChanges : undefined;
      })),
      asyncResetUnsavedChanges: async () => {
        controlGroupUnsavedChanges.api.resetUnsavedChanges();
        resetControlsUnsavedChanges();
        const filtersReadyPromises = [];
        Object.values(children$.value).forEach(controlApi => {
          if ((0, _presentationPublishing.apiPublishesUnsavedChanges)(controlApi)) controlApi.resetUnsavedChanges();
          if ((0, _publishes_async_filters.apiPublishesAsyncFilters)(controlApi)) {
            filtersReadyPromises.push(controlApi.untilFiltersReady());
          }
        });
        await Promise.all(filtersReadyPromises);
        if (!comparators.autoApplySelections[0].value) {
          applySelections();
        }
      }
    }
  };
}