"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConsoleWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _eui = require("@elastic/eui");
var localStorageObjectClient = _interopRequireWildcard(require("../../../lib/local_storage_object_client"));
var _kb = require("../../../lib/kb");
var _services = require("../../../services");
var _tracker = require("../../../services/tracker");
var _lib = require("../../lib");
var _contexts = require("../../contexts");
var _main = require("../main");
var _components = require("../../components");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const loadDependencies = async (core, usageCollection) => {
  const {
    docLinks: {
      DOC_LINK_VERSION,
      links
    },
    http,
    notifications,
    ...startServices
  } = core;
  const trackUiMetric = (0, _tracker.createUsageTracker)(usageCollection);
  trackUiMetric.load('opened_embedded_app');
  await (0, _kb.loadActiveApi)(core.http);
  const autocompleteInfo = (0, _services.getAutocompleteInfo)();
  const storage = (0, _services.getStorage)();
  const history = (0, _services.createHistory)({
    storage
  });
  const settings = (0, _services.createSettings)({
    storage
  });
  const objectStorageClient = localStorageObjectClient.create(storage);
  const api = (0, _lib.createApi)({
    http
  });
  const esHostService = (0, _lib.createEsHostService)({
    api
  });
  autocompleteInfo.mapping.setup(http, settings);
  return {
    ...startServices,
    autocompleteInfo,
    docLinks: links,
    docLinkVersion: DOC_LINK_VERSION,
    esHostService,
    history,
    http,
    notifications,
    objectStorageClient,
    settings,
    storage,
    theme$: startServices.theme.theme$,
    trackUiMetric
  };
};
const ConsoleWrapper = props => {
  const [dependencies, setDependencies] = (0, _react.useState)(null);
  const {
    core,
    usageCollection,
    onKeyDown,
    isDevMode,
    isOpen
  } = props;
  (0, _react.useEffect)(() => {
    if (dependencies === null && isOpen) {
      loadDependencies(core, usageCollection).then(setDependencies);
    }
  }, [dependencies, setDependencies, core, usageCollection, isOpen]);
  if (!dependencies && !isOpen) {
    // Console has not been opened
    return null;
  }
  if (!dependencies) {
    // Console open for the first time, wait for dependencies to load.
    return /*#__PURE__*/_react.default.createElement(_components.EditorContentSpinner, null);
  }
  const {
    autocompleteInfo,
    docLinkVersion,
    docLinks,
    esHostService,
    history,
    http,
    notifications,
    objectStorageClient,
    settings,
    storage,
    trackUiMetric,
    ...startServices
  } = dependencies;
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, core, /*#__PURE__*/_react.default.createElement(_contexts.ServicesContextProvider, {
    value: {
      ...startServices,
      docLinkVersion,
      docLinks,
      services: {
        esHostService,
        storage,
        history,
        settings,
        notifications,
        trackUiMetric,
        objectStorageClient,
        http,
        autocompleteInfo
      },
      config: {
        isDevMode
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_contexts.RequestContextProvider, null, /*#__PURE__*/_react.default.createElement(_contexts.EditorContextProvider, {
    settings: settings.toJSON()
  }, isOpen ? /*#__PURE__*/_react.default.createElement("div", {
    className: "embeddableConsole__content",
    "data-test-subj": "consoleEmbeddedBody"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiWindowEvent, {
    event: "keydown",
    handler: onKeyDown
  }), /*#__PURE__*/_react.default.createElement(_main.Main, {
    isEmbeddable: true
  })) : /*#__PURE__*/_react.default.createElement("span", null)))));
};
exports.ConsoleWrapper = ConsoleWrapper;