"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateSpecialAssignmentColor = exports.updatePalette = exports.updateModel = exports.updateGradientColorStep = exports.updateAssignmentRule = exports.updateAssignmentColor = exports.updateAssignment = exports.removeGradientColorStep = exports.removeAssignment = exports.removeAllAssignments = exports.colorMappingSlice = exports.colorMappingReducer = exports.changeGradientSortOrder = exports.changeColorMode = exports.assignStatically = exports.assignAutomatically = exports.addNewAssignments = exports.addNewAssignment = exports.addGradientColorStep = void 0;
var _toolkit = require("@reduxjs/toolkit");
var _default_color_mapping = require("../config/default_color_mapping");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const initialState = {
  assignments: [],
  specialAssignments: [],
  paletteId: 'eui',
  colorMode: {
    type: 'categorical'
  }
};
const colorMappingSlice = exports.colorMappingSlice = (0, _toolkit.createSlice)({
  name: 'colorMapping',
  initialState,
  reducers: {
    updateModel: (state, action) => {
      state.assignments = [...action.payload.assignments];
      state.specialAssignments = [...action.payload.specialAssignments];
      state.paletteId = action.payload.paletteId;
      state.colorMode = {
        ...action.payload.colorMode
      };
    },
    updatePalette: (state, action) => {
      state.paletteId = action.payload.paletteId;
      state.assignments = [...action.payload.assignments];
      state.colorMode = {
        ...action.payload.colorMode
      };
    },
    assignStatically: (state, action) => {
      state.assignments = [...action.payload];
    },
    assignAutomatically: state => {
      state.assignments = [];
    },
    addNewAssignment: (state, action) => {
      state.assignments.push({
        ...action.payload
      });
    },
    addNewAssignments: (state, action) => {
      state.assignments.push(...action.payload);
    },
    updateAssignment: (state, action) => {
      state.assignments[action.payload.assignmentIndex] = {
        ...action.payload.assignment,
        touched: true
      };
    },
    updateAssignmentRule: (state, action) => {
      state.assignments[action.payload.assignmentIndex] = {
        ...state.assignments[action.payload.assignmentIndex],
        rule: action.payload.rule
      };
    },
    updateAssignmentColor: (state, action) => {
      state.assignments[action.payload.assignmentIndex] = {
        ...state.assignments[action.payload.assignmentIndex],
        color: action.payload.color,
        touched: true
      };
    },
    updateSpecialAssignmentColor: (state, action) => {
      state.specialAssignments[action.payload.assignmentIndex] = {
        ...state.specialAssignments[action.payload.assignmentIndex],
        color: action.payload.color,
        touched: true
      };
    },
    removeAssignment: (state, action) => {
      state.assignments.splice(action.payload, 1);
      if (state.assignments.length === 0) {
        state.specialAssignments[_default_color_mapping.DEFAULT_OTHER_ASSIGNMENT_INDEX] = {
          ...state.specialAssignments[_default_color_mapping.DEFAULT_OTHER_ASSIGNMENT_INDEX],
          color: {
            type: 'loop'
          },
          touched: true
        };
      }
    },
    removeAllAssignments: state => {
      state.assignments = [];
      state.specialAssignments[_default_color_mapping.DEFAULT_OTHER_ASSIGNMENT_INDEX] = {
        ...state.specialAssignments[_default_color_mapping.DEFAULT_OTHER_ASSIGNMENT_INDEX],
        color: {
          type: 'loop'
        },
        touched: true
      };
    },
    changeColorMode: (state, action) => {
      state.colorMode = {
        ...action.payload
      };
    },
    updateGradientColorStep: (state, action) => {
      if (state.colorMode.type !== 'gradient') {
        return;
      }
      state.colorMode = {
        ...state.colorMode,
        steps: state.colorMode.steps.map((step, index) => {
          return index === action.payload.index ? {
            ...action.payload.color,
            touched: true
          } : {
            ...step,
            touched: false
          };
        })
      };
    },
    removeGradientColorStep: (state, action) => {
      if (state.colorMode.type !== 'gradient') {
        return;
      }
      const steps = [...state.colorMode.steps];
      steps.splice(action.payload, 1);

      // this maintain the correct sort direciton depending on which step
      // gets removed from the array when only 2 steps are left.
      const sort = state.colorMode.steps.length === 2 ? state.colorMode.sort === 'desc' ? action.payload === 0 ? 'asc' : 'desc' : action.payload === 0 ? 'desc' : 'asc' : state.colorMode.sort;
      state.colorMode = {
        ...state.colorMode,
        steps: [...steps],
        sort
      };
    },
    addGradientColorStep: (state, action) => {
      if (state.colorMode.type !== 'gradient') {
        return;
      }
      state.colorMode = {
        ...state.colorMode,
        steps: [...state.colorMode.steps.slice(0, action.payload.at), {
          ...action.payload.color,
          touched: false
        }, ...state.colorMode.steps.slice(action.payload.at)]
      };
    },
    changeGradientSortOrder: (state, action) => {
      if (state.colorMode.type !== 'gradient') {
        return;
      }
      state.colorMode = {
        ...state.colorMode,
        sort: action.payload
      };
    }
  }
});
// Action creators are generated for each case reducer function
const {
  updatePalette,
  assignStatically,
  assignAutomatically,
  addNewAssignment,
  addNewAssignments,
  updateAssignment,
  updateAssignmentColor,
  updateSpecialAssignmentColor,
  updateAssignmentRule,
  removeAssignment,
  removeAllAssignments,
  changeColorMode,
  updateGradientColorStep,
  removeGradientColorStep,
  addGradientColorStep,
  changeGradientSortOrder,
  updateModel
} = colorMappingSlice.actions;
exports.updateModel = updateModel;
exports.changeGradientSortOrder = changeGradientSortOrder;
exports.addGradientColorStep = addGradientColorStep;
exports.removeGradientColorStep = removeGradientColorStep;
exports.updateGradientColorStep = updateGradientColorStep;
exports.changeColorMode = changeColorMode;
exports.removeAllAssignments = removeAllAssignments;
exports.removeAssignment = removeAssignment;
exports.updateAssignmentRule = updateAssignmentRule;
exports.updateSpecialAssignmentColor = updateSpecialAssignmentColor;
exports.updateAssignmentColor = updateAssignmentColor;
exports.updateAssignment = updateAssignment;
exports.addNewAssignments = addNewAssignments;
exports.addNewAssignment = addNewAssignment;
exports.assignAutomatically = assignAutomatically;
exports.assignStatically = assignStatically;
exports.updatePalette = updatePalette;
const colorMappingReducer = exports.colorMappingReducer = colorMappingSlice.reducer;