"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_OTHER_ASSIGNMENT_INDEX = exports.DEFAULT_NEUTRAL_PALETTE_INDEX = exports.DEFAULT_COLOR_MAPPING_CONFIG = void 0;
exports.getColorsFromMapping = getColorsFromMapping;
exports.getPaletteColors = getPaletteColors;
exports.getPaletteColorsFromPaletteId = getPaletteColorsFromPaletteId;
var _palettes = require("../palettes");
var _eui_amsterdam = require("../palettes/eui_amsterdam");
var _neutral = require("../palettes/neutral");
var _color_handling = require("../color/color_handling");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DEFAULT_NEUTRAL_PALETTE_INDEX = exports.DEFAULT_NEUTRAL_PALETTE_INDEX = 1;
const DEFAULT_OTHER_ASSIGNMENT_INDEX = exports.DEFAULT_OTHER_ASSIGNMENT_INDEX = 0;

/**
 * The default color mapping used in Kibana, starts with the EUI color palette
 */
const DEFAULT_COLOR_MAPPING_CONFIG = exports.DEFAULT_COLOR_MAPPING_CONFIG = {
  assignments: [],
  specialAssignments: [{
    rule: {
      type: 'other'
    },
    color: {
      type: 'loop'
    },
    touched: false
  }],
  paletteId: _eui_amsterdam.EUIAmsterdamColorBlindPalette.id,
  colorMode: {
    type: 'categorical'
  }
};
function getPaletteColors(isDarkMode, colorMappings) {
  const colorMappingModel = colorMappings !== null && colorMappings !== void 0 ? colorMappings : {
    ...DEFAULT_COLOR_MAPPING_CONFIG
  };
  const palette = (0, _palettes.getPalette)(_palettes.AVAILABLE_PALETTES, _neutral.NeutralPalette)(colorMappingModel.paletteId);
  return getPaletteColorsFromPaletteId(isDarkMode, palette.id);
}
function getPaletteColorsFromPaletteId(isDarkMode, paletteId) {
  const palette = (0, _palettes.getPalette)(_palettes.AVAILABLE_PALETTES, _neutral.NeutralPalette)(paletteId);
  return Array.from({
    length: palette.colorCount
  }, (d, i) => palette.getColor(i, isDarkMode, true));
}
function getColorsFromMapping(isDarkMode, colorMappings) {
  const {
    colorMode,
    paletteId,
    assignments,
    specialAssignments
  } = colorMappings !== null && colorMappings !== void 0 ? colorMappings : {
    ...DEFAULT_COLOR_MAPPING_CONFIG
  };
  const getPaletteFn = (0, _palettes.getPalette)(_palettes.AVAILABLE_PALETTES, _neutral.NeutralPalette);
  if (colorMode.type === 'gradient') {
    const colorScale = (0, _color_handling.getGradientColorScale)(colorMode, getPaletteFn, isDarkMode);
    return Array.from({
      length: 6
    }, (d, i) => colorScale(i / 6));
  } else {
    const palette = getPaletteFn(paletteId);
    const otherColors = specialAssignments[DEFAULT_OTHER_ASSIGNMENT_INDEX].color.type === 'loop' ? Array.from({
      length: palette.colorCount
    }, (d, i) => palette.getColor(i, isDarkMode, true)) : [(0, _color_handling.getColor)(specialAssignments[DEFAULT_OTHER_ASSIGNMENT_INDEX].color, getPaletteFn, isDarkMode)];
    return [...assignments.map(a => {
      return a.color.type === 'gradient' ? '' : (0, _color_handling.getColor)(a.color, getPaletteFn, isDarkMode);
    }), ...otherColors].filter(color => color !== '');
  }
}