"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getColorAlpha = exports.enforceColorContrast = void 0;
exports.isValidColor = isValidColor;
exports.makeColorWithAlpha = void 0;
var _chromaJs = _interopRequireDefault(require("chroma-js"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const enforceColorContrast = (color, backgroundColor) => {
  const finalColor = (0, _chromaJs.default)(color).alpha() < 1 ? _chromaJs.default.blend(backgroundColor, color, 'overlay') : (0, _chromaJs.default)(color);
  return (0, _eui.isColorDark)(...finalColor.rgb());
};
exports.enforceColorContrast = enforceColorContrast;
function isValidColor(colorString) {
  // chroma can handle also hex values with alpha channel/transparency
  // chroma accepts also hex without #, so test for it
  return colorString != null && colorString !== '' && /^#/.test(colorString) && _chromaJs.default.valid(colorString);
}
const getColorAlpha = color => {
  var _chroma;
  return color && isValidColor(color) && ((_chroma = (0, _chromaJs.default)(color)) === null || _chroma === void 0 ? void 0 : _chroma.alpha()) || 1;
};
exports.getColorAlpha = getColorAlpha;
const makeColorWithAlpha = (color, newAlpha) => (0, _chromaJs.default)(color).alpha(newAlpha);
exports.makeColorWithAlpha = makeColorWithAlpha;