"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThirdPartyIntegrationsCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_wiz_integration_route = require("../../common/api/use_wiz_integration_route");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ThirdPartyIntegrationsCallout = () => {
  const wizAddIntegrationLink = (0, _use_wiz_integration_route.useAdd3PIntegrationRoute)('wiz');
  const [userHasDismissedCallout, setUserHasDismissedCallout] = (0, _useLocalStorage.default)(_constants.LOCAL_STORAGE_3P_INTEGRATIONS_CALLOUT_KEY);
  if (userHasDismissedCallout) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.csp.findings.3pIntegrationsCallout.title', {
      defaultMessage: "New! Ingest your cloud security product's data into Elastic for centralized analytics, hunting, investigations, visualizations, and more"
    }),
    iconType: "cheer",
    onDismiss: () => setUserHasDismissedCallout(true)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    href: wizAddIntegrationLink
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.findings.3pIntegrationsCallout.buttonTitle",
    defaultMessage: "Integrate Wiz"
  })));
};
exports.ThirdPartyIntegrationsCallout = ThirdPartyIntegrationsCallout;