"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppearanceModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _values_group = require("./values_group");
var _use_appearance_hook = require("./use_appearance_hook");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const systemLabel = _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.appearanceModalSystemLabel', {
  defaultMessage: 'System'
});
const colorModeOptions = [{
  id: 'system',
  label: systemLabel,
  icon: 'desktop'
}, {
  id: 'light',
  label: _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.appearanceModalLightLabel', {
    defaultMessage: 'Light'
  }),
  icon: 'sun'
}, {
  id: 'dark',
  label: _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.appearanceModalDarkLabel', {
    defaultMessage: 'Dark'
  }),
  icon: 'moon'
}, {
  id: 'space_default',
  label: _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.appearanceModalSpaceDefaultLabel', {
    defaultMessage: 'Space default'
  }),
  icon: 'spaces',
  betaBadgeLabel: _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.appearanceModalBetaBadgeLabel', {
    defaultMessage: 'Deprecated'
  }),
  betaBadgeTooltipContent: _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.appearanceModalBetaBadgeTooltip', {
    defaultMessage: 'Space default settings will be deprecated in 10.0.'
  }),
  betaBadgeIconType: 'warning'
}];
const AppearanceModal = ({
  closeModal,
  uiSettingsClient,
  isServerless
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    onChange,
    colorMode,
    isLoading,
    initialColorModeValue
  } = (0, _use_appearance_hook.useAppearance)({
    uiSettingsClient,
    defaultColorMode: isServerless ? 'system' : 'space_default'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    "aria-labelledby": modalTitleId,
    onClose: closeModal,
    style: isServerless ? undefined :
    // When not in serverless, we have the "Space default" as an option.
    // which renders a warning callout. We don't want the modal to scale up when
    // the callout is rendered, so we set a fixed width.
    {
      width: 580
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    size: "m",
    id: modalTitleId
  }, _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.appearanceModalTitle', {
    defaultMessage: 'Appearance'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_values_group.ValuesGroup, {
    title: _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.appearanceModalColorModeTitle', {
      defaultMessage: 'Color mode'
    }),
    values: isServerless ? colorModeOptions.filter(({
      id
    }) => id !== 'space_default') : colorModeOptions,
    selectedValue: colorMode,
    onChange: id => {
      onChange({
        colorMode: id
      }, false);
    },
    ariaLabel: _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.appearanceModalColorModeAriaLabel', {
      defaultMessage: 'Appearance color mode'
    })
  }), colorMode === 'space_default' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.appearanceModalDeprecatedSpaceDefaultTitle', {
      defaultMessage: 'Space default settings will be removed in a future version'
    }),
    color: "warning",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.appearanceModalDeprecatedSpaceDefaultDescr', {
    defaultMessage: 'All users with the Space default color mode enabled will be automatically transitioned to the System color mode.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "appearanceModalDiscardButton",
    onClick: closeModal
  }, _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.appearanceModalDiscardBtnLabel', {
    defaultMessage: 'Discard'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "appearanceModalSaveButton",
    onClick: async () => {
      if (colorMode !== initialColorModeValue) {
        await onChange({
          colorMode
        }, true);
      }
      closeModal();
    },
    fill: true,
    isLoading: isLoading
  }, _i18n.i18n.translate('xpack.cloudLinks.userMenuLinks.appearanceModalSaveBtnLabel', {
    defaultMessage: 'Save changes'
  }))));
};
exports.AppearanceModal = AppearanceModal;