"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isValidOwner = exports.getOwnerFromRuleConsumerProducer = exports.getCaseOwnerByAppId = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isValidOwner = owner => Object.keys(_constants.OWNER_INFO).includes(owner);
exports.isValidOwner = isValidOwner;
const getCaseOwnerByAppId = currentAppId => {
  var _Object$values$find;
  return (_Object$values$find = Object.values(_constants.OWNER_INFO).find(info => info.appId === currentAppId)) === null || _Object$values$find === void 0 ? void 0 : _Object$values$find.id;
};
exports.getCaseOwnerByAppId = getCaseOwnerByAppId;
const getOwnerFromRuleConsumerProducer = ({
  consumer,
  producer,
  isServerlessSecurity
}) => {
  // This is a workaround for a very specific bug with the cases action in serverless security
  // More info here: https://github.com/elastic/kibana/issues/186270
  if (isServerlessSecurity) {
    return _constants.OWNER_INFO.securitySolution.id;
  }

  // Fallback to producer if the consumer is alerts
  const consumerValue = consumer === _ruleDataUtils.AlertConsumers.ALERTS ? producer : consumer;
  for (const value of Object.values(_constants.OWNER_INFO)) {
    var _value$validRuleConsu;
    const foundConsumer = (_value$validRuleConsu = value.validRuleConsumers) === null || _value$validRuleConsu === void 0 ? void 0 : _value$validRuleConsu.find(validConsumer => validConsumer === consumerValue || validConsumer === producer);
    if (foundConsumer) {
      return value.id;
    }
  }
  return _constants.OWNER_INFO.cases.id;
};
exports.getOwnerFromRuleConsumerProducer = getOwnerFromRuleConsumerProducer;