"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.visualizationsService = exports.untilPluginStartServicesReady = exports.uiActionsService = exports.spacesService = exports.setKibanaServices = exports.reportingService = exports.presentationUtilService = exports.kibanaVersion = exports.expressionsService = exports.embeddableService = exports.dataViewsService = exports.dataService = exports.coreServices = exports.contentManagementService = void 0;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

let kibanaVersion = exports.kibanaVersion = void 0;
let coreServices = exports.coreServices = void 0;
let contentManagementService = exports.contentManagementService = void 0;
let dataService = exports.dataService = void 0;
let dataViewsService = exports.dataViewsService = void 0;
let embeddableService = exports.embeddableService = void 0;
let expressionsService = exports.expressionsService = void 0;
let presentationUtilService = exports.presentationUtilService = void 0;
let reportingService = exports.reportingService = void 0;
let spacesService = exports.spacesService = void 0;
let uiActionsService = exports.uiActionsService = void 0;
let visualizationsService = exports.visualizationsService = void 0;
const servicesReady$ = new _rxjs.BehaviorSubject(false);
const setKibanaServices = (kibanaCore, deps, initContext) => {
  var _deps$reporting, _kibanaCore$applicati;
  exports.kibanaVersion = kibanaVersion = initContext.env.packageInfo.version;
  exports.coreServices = coreServices = kibanaCore;
  exports.contentManagementService = contentManagementService = deps.contentManagement;
  exports.dataService = dataService = deps.data;
  exports.dataViewsService = dataViewsService = deps.dataViews;
  exports.embeddableService = embeddableService = deps.embeddable;
  exports.expressionsService = expressionsService = deps.expressions;
  exports.presentationUtilService = presentationUtilService = deps.presentationUtil;
  exports.reportingService = reportingService = Boolean(((_deps$reporting = deps.reporting) === null || _deps$reporting === void 0 ? void 0 : _deps$reporting.usesUiCapabilities()) && !((_kibanaCore$applicati = kibanaCore.application.capabilities.canvas) !== null && _kibanaCore$applicati !== void 0 && _kibanaCore$applicati.generatePdf)) ? undefined : deps.reporting;
  exports.spacesService = spacesService = deps.spaces;
  exports.uiActionsService = uiActionsService = deps.uiActions;
  exports.visualizationsService = visualizationsService = deps.visualizations;
  servicesReady$.next(true);
};
exports.setKibanaServices = setKibanaServices;
const untilPluginStartServicesReady = () => {
  if (servicesReady$.value) return Promise.resolve();
  return new Promise(resolve => {
    const subscription = servicesReady$.subscribe(isInitialized => {
      if (isInitialized) {
        subscription.unsubscribe();
        resolve();
      }
    });
  });
};
exports.untilPluginStartServicesReady = untilPluginStartServicesReady;