"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRefreshHelper = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _workpad_routing_context = require("../workpad_routing_context");
var _resolved_args = require("../../../state/selectors/resolved_args");
var _elements = require("../../../state/actions/elements");
var _use_canvas_api = require("../../../components/hooks/use_canvas_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error untyped local

const useRefreshHelper = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    refreshInterval
  } = (0, _react.useContext)(_workpad_routing_context.WorkpadRoutingContext);
  const timer = (0, _react.useRef)(undefined);
  const inFlight = (0, _reactRedux.useSelector)(_resolved_args.getInFlight);
  (0, _react.useEffect)(() => {
    // We got here because inFlight or refreshInterval changed.
    // Either way, we want to cancel existing refresh timer
    clearTimeout(timer.current);
    if (refreshInterval > 0 && !inFlight) {
      timer.current = window.setTimeout(() => {
        (0, _use_canvas_api.forceReload)();
        dispatch((0, _elements.fetchAllRenderables)());
      }, refreshInterval);
    }
    return () => {
      clearTimeout(timer.current);
    };
  }, [inFlight, dispatch, refreshInterval]);
};
exports.useRefreshHelper = useRefreshHelper;