"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getErrorGroupMainStatistics = getErrorGroupMainStatistics;
var _server = require("@kbn/observability-plugin/server");
var _utils = require("@kbn/apm-data-access-plugin/server/utils");
var _as_mutable_array = require("../../../../common/utils/as_mutable_array");
var _apm = require("../../../../common/es_fields/apm");
var _environment_query = require("../../../../common/utils/environment_query");
var _get_error_name = require("../../../lib/helpers/get_error_name");
var _document_type = require("../../../../common/document_type");
var _rollup = require("../../../../common/rollup");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getErrorGroupMainStatistics({
  kuery,
  serviceName,
  apmEventClient,
  environment,
  sortField,
  sortDirection = 'desc',
  start,
  end,
  maxNumberOfErrorGroups = 500,
  transactionName,
  transactionType,
  searchQuery
}) {
  var _response$aggregation, _response$aggregation2, _response$aggregation3, _response$aggregation4;
  // sort buckets by last occurrence of error
  const sortByLatestOccurrence = sortField === 'lastSeen';
  const maxTimestampAggKey = 'max_timestamp';
  const order = sortByLatestOccurrence ? {
    [maxTimestampAggKey]: sortDirection
  } : {
    _count: sortDirection
  };
  const shouldMatchSearchQuery = searchQuery ? [{
    bool: {
      should: [_apm.ERROR_LOG_MESSAGE, _apm.ERROR_EXC_MESSAGE, _apm.ERROR_GROUP_NAME, _apm.ERROR_EXC_TYPE, _apm.ERROR_CULPRIT].flatMap(field => (0, _server.wildcardQuery)(field, searchQuery)),
      minimum_should_match: 1
    }
  }] : [];
  const requiredFields = (0, _as_mutable_array.asMutableArray)([_apm.AT_TIMESTAMP, _apm.ERROR_GROUP_ID]);
  const optionalFields = (0, _as_mutable_array.asMutableArray)([_apm.TRACE_ID, _apm.ERROR_CULPRIT, _apm.ERROR_LOG_MESSAGE, _apm.ERROR_EXC_MESSAGE, _apm.ERROR_EXC_HANDLED, _apm.ERROR_EXC_TYPE]);
  const response = await apmEventClient.search('get_error_group_main_statistics', {
    apm: {
      sources: [{
        documentType: _document_type.ApmDocumentType.ErrorEvent,
        rollupInterval: _rollup.RollupInterval.None
      }]
    },
    body: {
      track_total_hits: false,
      size: 0,
      query: {
        bool: {
          filter: [...(0, _server.termQuery)(_apm.SERVICE_NAME, serviceName), ...(0, _server.termQuery)(_apm.TRANSACTION_NAME, transactionName), ...(0, _server.termQuery)(_apm.TRANSACTION_TYPE, transactionType), ...(0, _server.rangeQuery)(start, end), ...(0, _environment_query.environmentQuery)(environment), ...(0, _server.kqlQuery)(kuery), ...shouldMatchSearchQuery]
        }
      },
      aggs: {
        error_groups: {
          terms: {
            field: _apm.ERROR_GROUP_ID,
            size: maxNumberOfErrorGroups,
            order
          },
          aggs: {
            sample: {
              top_hits: {
                size: 1,
                fields: [...requiredFields, ...optionalFields],
                _source: [_apm.ERROR_LOG_MESSAGE, _apm.ERROR_EXC_MESSAGE, _apm.ERROR_EXC_HANDLED, _apm.ERROR_EXC_TYPE],
                sort: {
                  '@timestamp': 'desc'
                }
              }
            },
            ...(sortByLatestOccurrence ? {
              [maxTimestampAggKey]: {
                max: {
                  field: '@timestamp'
                }
              }
            } : {})
          }
        }
      }
    }
  });
  const maxCountExceeded = ((_response$aggregation = (_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : _response$aggregation2.error_groups.sum_other_doc_count) !== null && _response$aggregation !== void 0 ? _response$aggregation : 0) > 0;
  const errorGroups = (_response$aggregation3 = (_response$aggregation4 = response.aggregations) === null || _response$aggregation4 === void 0 ? void 0 : _response$aggregation4.error_groups.buckets.map(bucket => {
    var _event$error, _errorSource$error$ex, _errorSource$error$ex2, _mergedEvent$error$ex, _mergedEvent$error$ex2, _mergedEvent$trace;
    const errorSource = 'error' in bucket.sample.hits.hits[0]._source ? bucket.sample.hits.hits[0]._source : undefined;
    const event = (0, _utils.unflattenKnownApmEventFields)(bucket.sample.hits.hits[0].fields, requiredFields);
    const mergedEvent = {
      ...event,
      error: {
        ...((_event$error = event.error) !== null && _event$error !== void 0 ? _event$error : {}),
        exception: ((_errorSource$error$ex = errorSource === null || errorSource === void 0 ? void 0 : (_errorSource$error$ex2 = errorSource.error.exception) === null || _errorSource$error$ex2 === void 0 ? void 0 : _errorSource$error$ex2.length) !== null && _errorSource$error$ex !== void 0 ? _errorSource$error$ex : 0) > 0 ? errorSource === null || errorSource === void 0 ? void 0 : errorSource.error.exception : (event === null || event === void 0 ? void 0 : event.error.exception) && [event.error.exception]
      }
    };
    return {
      groupId: bucket.key,
      name: (0, _get_error_name.getErrorName)(mergedEvent),
      lastSeen: new Date(mergedEvent[_apm.AT_TIMESTAMP]).getTime(),
      occurrences: bucket.doc_count,
      culprit: mergedEvent.error.culprit,
      handled: (_mergedEvent$error$ex = mergedEvent.error.exception) === null || _mergedEvent$error$ex === void 0 ? void 0 : _mergedEvent$error$ex[0].handled,
      type: (_mergedEvent$error$ex2 = mergedEvent.error.exception) === null || _mergedEvent$error$ex2 === void 0 ? void 0 : _mergedEvent$error$ex2[0].type,
      traceId: (_mergedEvent$trace = mergedEvent.trace) === null || _mergedEvent$trace === void 0 ? void 0 : _mergedEvent$trace.id
    };
  })) !== null && _response$aggregation3 !== void 0 ? _response$aggregation3 : [];
  return {
    errorGroups,
    maxCountExceeded
  };
}