"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGlobalApmServerRouteRepository = void 0;
var _route = require("../agent_explorer/route");
var _route2 = require("../agent_keys/route");
var _route3 = require("../alerts/route");
var _route4 = require("../assistant_functions/route");
var _route5 = require("../correlations/route");
var _route6 = require("../custom_dashboards/route");
var _route7 = require("../data_view/route");
var _route8 = require("../debug_telemetry/route");
var _route9 = require("../dependencies/route");
var _route10 = require("../diagnostics/route");
var _route11 = require("../environments/route");
var _route12 = require("../errors/route");
var _route13 = require("../event_metadata/route");
var _route14 = require("../fallback_to_transactions/route");
var _route15 = require("../fleet/route");
var _route16 = require("../historical_data/route");
var _route17 = require("../infrastructure/route");
var _route18 = require("../latency_distribution/route");
var _route19 = require("../metrics/route");
var _route20 = require("../mobile/route");
var _route21 = require("../observability_overview/route");
var _route22 = require("../profiling/hosts/route");
var _route23 = require("../profiling/route");
var _route24 = require("../services/route");
var _route25 = require("../service_groups/route");
var _route26 = require("../service_map/route");
var _route27 = require("../settings/agent_configuration/route");
var _route28 = require("../settings/anomaly_detection/route");
var _route29 = require("../settings/apm_indices/route");
var _route30 = require("../settings/custom_link/route");
var _route31 = require("../settings/labs/route");
var _route32 = require("../source_maps/route");
var _route33 = require("../span_links/route");
var _route34 = require("../storage_explorer/route");
var _route35 = require("../suggestions/route");
var _route36 = require("../time_range_metadata/route");
var _route37 = require("../traces/route");
var _route38 = require("../transactions/route");
var _routes = require("../entities/services/routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getTypedGlobalApmServerRouteRepository() {
  const repository = {
    ..._route7.dataViewRouteRepository,
    ..._route11.environmentsRouteRepository,
    ..._route12.errorsRouteRepository,
    ..._route18.latencyDistributionRouteRepository,
    ..._route19.metricsRouteRepository,
    ..._route21.observabilityOverviewRouteRepository,
    ..._route26.serviceMapRouteRepository,
    ..._route24.serviceRouteRepository,
    ..._routes.servicesEntitiesRoutesRepository,
    ..._route25.serviceGroupRouteRepository,
    ..._route35.suggestionsRouteRepository,
    ..._route37.traceRouteRepository,
    ..._route38.transactionRouteRepository,
    ..._route3.alertsChartPreviewRouteRepository,
    ..._route27.agentConfigurationRouteRepository,
    ..._route28.anomalyDetectionRouteRepository,
    ..._route29.apmIndicesRouteRepository,
    ..._route30.customLinkRouteRepository,
    ..._route32.sourceMapsRouteRepository,
    ..._route15.apmFleetRouteRepository,
    ..._route9.dependencisRouteRepository,
    ..._route5.correlationsRouteRepository,
    ..._route14.fallbackToTransactionsRouteRepository,
    ..._route16.historicalDataRouteRepository,
    ..._route13.eventMetadataRouteRepository,
    ..._route2.agentKeysRouteRepository,
    ..._route34.storageExplorerRouteRepository,
    ..._route33.spanLinksRouteRepository,
    ..._route17.infrastructureRouteRepository,
    ..._route8.debugTelemetryRoute,
    ..._route36.timeRangeMetadataRoute,
    ..._route31.labsRouteRepository,
    ..._route.agentExplorerRouteRepository,
    ..._route20.mobileRouteRepository,
    ..._route10.diagnosticsRepository,
    ..._route4.assistantRouteRepository,
    ..._route23.profilingRouteRepository,
    ..._route22.profilingHostsRouteRepository,
    ..._route6.serviceDashboardsRouteRepository
  };
  return repository;
}
const getGlobalApmServerRouteRepository = () => {
  return getTypedGlobalApmServerRouteRepository();
};

// Ensure no APIs return arrays (or, by proxy, the any type),
// to guarantee compatibility with _inspect.
exports.getGlobalApmServerRouteRepository = getGlobalApmServerRouteRepository;
function assertType() {}

// if any endpoint has an array-like return type, the assertion below will fail
assertType();