"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TruncateWithTooltip = TruncateWithTooltip;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _style = require("../../../utils/style");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const tooltipAnchorClassname = '_apm_truncate_tooltip_anchor_';
const TooltipWrapper = _common.euiStyled.div`
  width: 100%;
  .${tooltipAnchorClassname} {
    width: 100% !important;
    display: block !important;
  }
`;
const ContentWrapper = _common.euiStyled.div`
  ${(0, _style.truncate)('100%')}
`;
function TruncateWithTooltip(props) {
  const {
    text,
    content,
    ...rest
  } = props;
  return /*#__PURE__*/_react.default.createElement(TooltipWrapper, rest, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    delay: "long",
    content: text,
    anchorClassName: tooltipAnchorClassname
  }, /*#__PURE__*/_react.default.createElement(ContentWrapper, null, content || text)));
}