"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.existingDashboardFileNames = void 0;
exports.loadDashboardFile = loadDashboardFile;
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// The new dashboard file names should be added here
const existingDashboardFileNames = exports.existingDashboardFileNames = new Set(['classic_apm-apm-nodejs', 'classic_apm-apm-java', 'classic_apm-otel_other-nodejs', 'classic_apm-otel_other-java', 'classic_apm-otel_other-dotnet', 'classic_apm-edot-nodejs', 'classic_apm-edot-java', 'otel_native-edot-java', 'otel_native-otel_other-java', 'classic_apm-edot-dotnet', 'otel_native-edot-python', 'otel_native-otel_other-python', 'otel_native-edot-nodejs', 'classic_apm-otel_other-go', 'otel_native-otel_other-go']);

// The new dashboard files should be mapped here
// + changed with the new ones (following the naming convention)
// + similar mapping for edot needed
//     - example: otel_native-edot-nodejs
async function loadDashboardFile(filename) {
  switch (filename) {
    case 'classic_apm-apm-nodejs':
      {
        return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "lazyNodeJsClassicApmDashboard" */
        './nodejs.json')));
      }
    case 'classic_apm-otel_other-nodejs':
      {
        return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "lazyNodeJsApmOtelDashboard" */
        './opentelemetry_nodejs.json')));
      }
    case 'classic_apm-edot-nodejs':
      {
        return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "lazyNodeJsOtelNativeDashboard" */
        './opentelemetry_nodejs.json')));
      }
    case 'classic_apm-apm-java':
      {
        return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "lazyJavaClassicApmDashboard" */
        './java.json')));
      }
    case 'classic_apm-otel_other-java':
      {
        return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "lazyJavaApmOtelDashboard" */
        './opentelemetry_java.json')));
      }
    case 'classic_apm-edot-java':
      {
        return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "lazyJavaOtelNativeDashboard" */
        './opentelemetry_java.json')));
      }
    case 'otel_native-otel_other-java':
      {
        return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "lazyJavaOtelNativeOtherDashboard" */
        './otel_native-otel_other-java.json')));
      }
    case 'otel_native-edot-java':
      {
        return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "lazyJavaOtelNativeEdotDashboard" */
        './otel_native-edot-java.json')));
      }
    case 'classic_apm-edot-dotnet':
      {
        return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "lazyDotnetOtelNativeDashboard" */
        './opentelemetry_dotnet.json')));
      }
    case 'classic_apm-otel_other-dotnet':
      {
        return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "lazyDotnetApmOtelDashboard" */
        './opentelemetry_dotnet.json')));
      }
    case 'otel_native-otel_other-python':
      {
        return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "lazyPythonOtelNativeOtherDashboard" */
        './otel_native-otel_other-python.json')));
      }
    case 'otel_native-edot-python':
      {
        return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "lazyPythonOtelNativeEdotDashboard" */
        './otel_native-edot-python.json')));
      }
    case 'otel_native-edot-nodejs':
      {
        return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "lazyNodeJsOtelNativeEdotDashboard" */
        './otel_native-edot-nodejs.json')));
      }
    case 'otel_native-otel_other-go':
    case 'classic_apm-otel_other-go':
      {
        return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "lazyGoOtelNativeDashboard" */
        './otel_native-otel_other-go.json')));
      }
    default:
      {
        break;
      }
  }
}