"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityLink = EntityLink;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedSvg = require("@kbn/shared-svg");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _environment_filter_values = require("../../../../../common/environment_filter_values");
var _use_service_entity_summary_fetcher = require("../../../../context/apm_service/use_service_entity_summary_fetcher");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_apm_router = require("../../../../hooks/use_apm_router");
var _use_entity_centric_experience_setting = require("../../../../hooks/use_entity_centric_experience_setting");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_theme = require("../../../../hooks/use_theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const pageHeader = {
  pageTitle: 'APM'
};
function EntityLink() {
  const router = (0, _use_apm_router.useApmRouter)({
    prependBasePath: false
  });
  const theme = (0, _use_theme.useTheme)();
  const {
    services
  } = (0, _public.useKibana)();
  const {
    observabilityShared,
    data
  } = services;
  const timeRange = data.query.timefilter.timefilter.getTime();
  const ObservabilityPageTemplate = observabilityShared.navigation.PageTemplate;
  const {
    path: {
      serviceName
    },
    query: {
      rangeFrom = timeRange.from,
      rangeTo = timeRange.to
    }
  } = (0, _use_apm_params.useApmParams)('/link-to/entity/{serviceName}');
  const {
    isEntityCentricExperienceEnabled
  } = (0, _use_entity_centric_experience_setting.useEntityCentricExperienceSetting)();
  const {
    serviceEntitySummary,
    serviceEntitySummaryStatus
  } = (0, _use_service_entity_summary_fetcher.useServiceEntitySummaryFetcher)({
    serviceName,
    environment: _environment_filter_values.ENVIRONMENT_ALL_VALUE
  });
  const {
    data: hasApmData,
    status: hasApmDataStatus
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/has_data');
  }, []);
  if (serviceEntitySummaryStatus === _use_fetcher.FETCH_STATUS.LOADING || (0, _use_fetcher.isPending)(hasApmDataStatus)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      "data-test-subj": "apmEntityLinkLoadingSpinner"
    });
  }
  if (
  // When EEM is enabled and the service is not found on the EEM indices and there's no APM data, display a callout guiding on the limitations of EEM
  isEntityCentricExperienceEnabled === true && ((serviceEntitySummary === null || serviceEntitySummary === void 0 ? void 0 : serviceEntitySummary.dataStreamTypes) === undefined || serviceEntitySummary.dataStreamTypes.length === 0) && (hasApmData === null || hasApmData === void 0 ? void 0 : hasApmData.hasData) !== true) {
    return /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
      pageHeader: pageHeader
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      "data-test-subj": "apmEntityLinkEEMCallout",
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
        size: "fullWidth",
        src: theme.darkMode ? _sharedSvg.dashboardsDark : _sharedSvg.dashboardsLight,
        alt: ""
      }),
      title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.apm.entityLink.eemGuide.title', {
        defaultMessage: 'Service not supported'
      })),
      body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.apm.entityLink.eemGuide.description",
        defaultMessage: "Sorry, we aren't able to provide you with more details on this service yet due to {limitationsLink}.",
        values: {
          limitationsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            target: "_blank",
            "data-test-subj": "apmEntityLinkLimitationsWithTheElasticEntityModelLink",
            href: "https://ela.st/eem-limitations"
          }, _i18n.i18n.translate('xpack.apm.entityLink.eemGuide.description.link', {
            defaultMessage: 'limitations with the Elastic Entity Model'
          }))
        }
      })),
      actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        "data-test-subj": "apmEntityLinkGoBackButton",
        iconType: "arrowLeft",
        onClick: () => {
          window.history.back();
        }
      }, _i18n.i18n.translate('xpack.apm.entityLink.eemGuide.goBackButtonLabel', {
        defaultMessage: 'Go back'
      }))]
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: router.link('/services/{serviceName}/overview', {
      path: {
        serviceName
      },
      query: {
        rangeFrom,
        rangeTo,
        kuery: '',
        serviceGroup: '',
        comparisonEnabled: true,
        environment: _environment_filter_values.ENVIRONMENT_ALL_VALUE
      }
    })
  });
}