"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transactionErrorRateRecoveryMessage = exports.transactionErrorRateMessage = exports.transactionDurationRecoveryMessage = exports.transactionDurationMessage = exports.errorCountRecoveryMessage = exports.errorCountMessage = exports.anomalyRecoveryMessage = exports.anomalyMessage = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const errorCountMessage = exports.errorCountMessage = _i18n.i18n.translate('xpack.apm.alertTypes.errorCount.defaultActionMessage', {
  defaultMessage: `'{{context.reason}}'

'{{rule.name}}' is active with the following conditions:

- Service name: '{{context.serviceName}}'
- Environment: '{{context.environment}}'
- Error count: '{{context.triggerValue}}' errors over the last '{{context.interval}}'
- Threshold: '{{context.threshold}}'

[View alert details]('{{context.alertDetailsUrl}}')
`
});
const errorCountRecoveryMessage = exports.errorCountRecoveryMessage = _i18n.i18n.translate('xpack.apm.alertTypes.errorCount.defaultRecoveryMessage', {
  defaultMessage: `'{{context.reason}}'

'{{rule.name}}' has recovered.

- Service name: '{{context.serviceName}}'
- Environment: '{{context.environment}}'
- Error count: '{{context.triggerValue}}' errors over the last '{{context.interval}}'
- Threshold: '{{context.threshold}}'

[View alert details]('{{context.alertDetailsUrl}}')
`
});
const transactionDurationMessage = exports.transactionDurationMessage = _i18n.i18n.translate('xpack.apm.alertTypes.transactionDuration.defaultActionMessage', {
  defaultMessage: `'{{context.reason}}'

'{{rule.name}}' is active with the following conditions:

- Service name: '{{context.serviceName}}'
- Transaction type: '{{context.transactionType}}'
- Transaction name: '{{context.transactionName}}'
- Environment: '{{context.environment}}'
- Latency: '{{context.triggerValue}}' over the last '{{context.interval}}'
- Threshold: '{{context.threshold}}'ms

[View alert details]('{{context.alertDetailsUrl}}')
`
});
const transactionDurationRecoveryMessage = exports.transactionDurationRecoveryMessage = _i18n.i18n.translate('xpack.apm.alertTypes.transactionDuration.defaultRecoveryMessage', {
  defaultMessage: `'{{context.reason}}'

'{{rule.name}}' has recovered.

- Service name: '{{context.serviceName}}'
- Transaction type: '{{context.transactionType}}'
- Transaction name: '{{context.transactionName}}'
- Environment: '{{context.environment}}'
- Latency: '{{context.triggerValue}}' over the last '{{context.interval}}'
- Threshold: '{{context.threshold}}'ms

[View alert details]('{{context.alertDetailsUrl}}')
`
});
const transactionErrorRateMessage = exports.transactionErrorRateMessage = _i18n.i18n.translate('xpack.apm.alertTypes.transactionErrorRate.defaultActionMessage', {
  defaultMessage: `'{{context.reason}}'

'{{rule.name}}' is active with the following conditions:

- Service name: '{{context.serviceName}}'
- Transaction type: '{{context.transactionType}}'
- Environment: '{{context.environment}}'
- Failed transaction rate: '{{context.triggerValue}}'% of errors over the last '{{context.interval}}'
- Threshold: '{{context.threshold}}'%

[View alert details]('{{context.alertDetailsUrl}}')
`
});
const transactionErrorRateRecoveryMessage = exports.transactionErrorRateRecoveryMessage = _i18n.i18n.translate('xpack.apm.alertTypes.transactionErrorRate.defaultRecoveryMessage', {
  defaultMessage: `'{{context.reason}}'

'{{rule.name}}' has recovered.

- Service name: '{{context.serviceName}}'
- Transaction type: '{{context.transactionType}}'
- Environment: '{{context.environment}}'
- Failed transaction rate: '{{context.triggerValue}}'% of errors over the last '{{context.interval}}'
- Threshold: '{{context.threshold}}'%

[View alert details]('{{context.alertDetailsUrl}}')
`
});
const anomalyMessage = exports.anomalyMessage = _i18n.i18n.translate('xpack.apm.alertTypes.transactionDurationAnomaly.defaultActionMessage', {
  defaultMessage: `'{{context.reason}}'

'{{rule.name}}' is active with the following conditions:

- Service name: '{{context.serviceName}}'
- Transaction type: '{{context.transactionType}}'
- Environment: '{{context.environment}}'
- Severity: '{{context.triggerValue}}'
- Threshold: '{{context.threshold}}'

[View alert details]('{{context.alertDetailsUrl}}')
`
});
const anomalyRecoveryMessage = exports.anomalyRecoveryMessage = _i18n.i18n.translate('xpack.apm.alertTypes.transactionDurationAnomaly.defaultRecoveryMessage', {
  defaultMessage: `'{{context.reason}}'

'{{rule.name}}' has recovered.

- Service name: '{{context.serviceName}}'
- Transaction type: '{{context.transactionType}}'
- Environment: '{{context.environment}}'
- Severity: '{{context.triggerValue}}'
- Threshold: '{{context.threshold}}'

[View alert details]('{{context.alertDetailsUrl}}')
`
});