"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStorageSizeRt = getStorageSizeRt;
var t = _interopRequireWildcard(require("io-ts"));
var _Either = require("fp-ts/lib/Either");
var _amount_and_unit = require("../amount_and_unit");
var _get_range_type_message = require("./get_range_type_message");
var _is_finite_number = require("../../utils/is_finite_number");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const units = ['B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB'];
function toBytes(amount, unit, decimalUnitBase) {
  const base = decimalUnitBase ? 1000 : 1024;
  const unitExponent = unit ? units.indexOf(unit.toUpperCase()) : 0;
  if (unitExponent < 0) {
    return;
  }
  return amount * base ** unitExponent;
}
function amountAndUnitToBytes({
  value,
  decimalUnitBase
}) {
  if (value) {
    const {
      amount,
      unit
    } = (0, _amount_and_unit.amountAndUnitToObject)(value);
    if ((0, _is_finite_number.isFiniteNumber)(amount) && unit) {
      return toBytes(amount, unit, decimalUnitBase);
    }
  }
}
function getStorageSizeRt({
  min,
  max
}) {
  var _amountAndUnitToBytes, _amountAndUnitToBytes2;
  const minAsBytes = (_amountAndUnitToBytes = amountAndUnitToBytes({
    value: min,
    decimalUnitBase: true
  })) !== null && _amountAndUnitToBytes !== void 0 ? _amountAndUnitToBytes : -Infinity;
  const maxAsBytes = (_amountAndUnitToBytes2 = amountAndUnitToBytes({
    value: max,
    decimalUnitBase: true
  })) !== null && _amountAndUnitToBytes2 !== void 0 ? _amountAndUnitToBytes2 : Infinity;
  const message = (0, _get_range_type_message.getRangeTypeMessage)(min, max);
  return new t.Type('storageSizeRt', t.string.is, (input, context) => {
    return _Either.either.chain(t.string.validate(input, context), inputAsString => {
      const inputAsBytes = amountAndUnitToBytes({
        value: inputAsString,
        decimalUnitBase: true
      });
      const isValidAmount = inputAsBytes !== undefined && inputAsBytes >= minAsBytes && inputAsBytes <= maxAsBytes;
      return isValidAmount ? t.success(inputAsString) : t.failure(input, context, message);
    });
  }, t.identity);
}