"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AAD_INDEX_PATTERN = void 0;
exports.getTotalAlertsCountAggregations = getTotalAlertsCountAggregations;
var _alerting_usage_collector = require("../alerting_usage_collector");
var _parse_simple_rule_type_bucket = require("./parse_simple_rule_type_bucket");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AAD_INDEX_PATTERN = exports.AAD_INDEX_PATTERN = '.alerts-*';
async function getTotalAlertsCountAggregations({
  esClient,
  logger
}) {
  try {
    var _results$hits$total;
    const query = {
      index: AAD_INDEX_PATTERN,
      size: 0,
      body: {
        query: {
          match_all: {}
        },
        aggs: {
          by_rule_type_id: {
            terms: {
              field: 'kibana.alert.rule.rule_type_id',
              size: _alerting_usage_collector.NUM_ALERTING_RULE_TYPES
            }
          }
        }
      }
    };
    logger.debug(() => `query for getTotalAlertsCountAggregations - ${JSON.stringify(query)}`);
    const results = await esClient.search(query);
    logger.debug(() => `results for getTotalAlertsCountAggregations query - ${JSON.stringify(results)}`);
    const totalAlertsCount = typeof results.hits.total === 'number' ? results.hits.total : (_results$hits$total = results.hits.total) === null || _results$hits$total === void 0 ? void 0 : _results$hits$total.value;
    const aggregations = results.aggregations;
    return {
      hasErrors: false,
      count_alerts_total: totalAlertsCount !== null && totalAlertsCount !== void 0 ? totalAlertsCount : 0,
      count_alerts_by_rule_type: (0, _parse_simple_rule_type_bucket.parseSimpleRuleTypeBucket)(aggregations.by_rule_type_id.buckets)
    };
  } catch (err) {
    const errorMessage = err && err.message ? err.message : err.toString();
    logger.warn(`Error executing alerting telemetry task: getTotalAlertsCountAggregations - ${JSON.stringify(err)}`, {
      tags: ['alerting', 'telemetry-failed'],
      error: {
        stack_trace: err.stack
      }
    });
    return {
      hasErrors: true,
      errorMessage,
      count_alerts_total: 0,
      count_alerts_by_rule_type: {}
    };
  }
}