"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionScheduler = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _server = require("@kbn/task-manager-plugin/server");
var _create_execute_function = require("@kbn/actions-plugin/server/create_execute_function");
var _alertingStateTypes = require("@kbn/alerting-state-types");
var _lodash = require("lodash");
var _lib = require("./lib");
var _lib2 = require("../lib");
var schedulers = _interopRequireWildcard(require("./schedulers"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BULK_SCHEDULE_CHUNK_SIZE = 1000;
class ActionScheduler {
  constructor(context) {
    (0, _defineProperty2.default)(this, "schedulers", []);
    (0, _defineProperty2.default)(this, "ephemeralActionsToSchedule", void 0);
    this.context = context;
    this.ephemeralActionsToSchedule = context.taskRunnerContext.maxEphemeralActionsPerRule;
    for (const [_, scheduler] of Object.entries(schedulers)) {
      this.schedulers.push(new scheduler(context));
    }

    // sort schedulers by priority
    this.schedulers.sort((a, b) => a.priority - b.priority);
  }
  async run({
    activeCurrentAlerts,
    recoveredCurrentAlerts
  }) {
    var _this$context$taskIns;
    const throttledSummaryActions = (0, _lib.getSummaryActionsFromTaskState)({
      actions: this.context.rule.actions,
      summaryActions: (_this$context$taskIns = this.context.taskInstance.state) === null || _this$context$taskIns === void 0 ? void 0 : _this$context$taskIns.summaryActions
    });
    const allActionsToScheduleResult = [];
    for (const scheduler of this.schedulers) {
      allActionsToScheduleResult.push(...(await scheduler.getActionsToSchedule({
        activeCurrentAlerts,
        recoveredCurrentAlerts,
        throttledSummaryActions
      })));
    }
    if (allActionsToScheduleResult.length === 0) {
      return {
        throttledSummaryActions
      };
    }
    const bulkScheduleRequest = [];
    for (const result of allActionsToScheduleResult) {
      await this.runActionAsEphemeralOrAddToBulkScheduleRequest({
        enqueueOptions: result.actionToEnqueue,
        bulkScheduleRequest
      });
    }
    let bulkScheduleResponse = [];
    if (!!bulkScheduleRequest.length) {
      for (const c of (0, _lodash.chunk)(bulkScheduleRequest, BULK_SCHEDULE_CHUNK_SIZE)) {
        let enqueueResponse;
        try {
          enqueueResponse = await (0, _lib2.withAlertingSpan)('alerting:bulk-enqueue-actions', () => this.context.actionsClient.bulkEnqueueExecution(c));
        } catch (e) {
          if (e.statusCode === 404) {
            throw (0, _server.createTaskRunError)(e, _server.TaskErrorSource.USER);
          }
          throw (0, _server.createTaskRunError)(e, _server.TaskErrorSource.FRAMEWORK);
        }
        if (enqueueResponse.errors) {
          bulkScheduleResponse = bulkScheduleResponse.concat(enqueueResponse.items.filter(i => i.response === _create_execute_function.ExecutionResponseType.QUEUED_ACTIONS_LIMIT_ERROR));
        }
      }
    }
    const actionsToNotLog = [];
    if (!!bulkScheduleResponse.length) {
      for (const r of bulkScheduleResponse) {
        if (r.response === _create_execute_function.ExecutionResponseType.QUEUED_ACTIONS_LIMIT_ERROR) {
          this.context.ruleRunMetricsStore.setHasReachedQueuedActionsLimit(true);
          this.context.ruleRunMetricsStore.decrementNumberOfTriggeredActions();
          this.context.ruleRunMetricsStore.decrementNumberOfTriggeredActionsByConnectorType(r.actionTypeId);
          this.context.ruleRunMetricsStore.setTriggeredActionsStatusByConnectorType({
            actionTypeId: r.actionTypeId,
            status: _alertingStateTypes.ActionsCompletion.PARTIAL
          });
          this.context.logger.debug(`Rule "${this.context.rule.id}" skipped scheduling action "${r.id}" because the maximum number of queued actions has been reached.`);
          const uuid = r.uuid;
          // uuid is typed as optional but in reality it is always
          // populated - https://github.com/elastic/kibana/issues/195255
          if (uuid) {
            actionsToNotLog.push(uuid);
          }
        }
      }
    }
    const actionsToLog = allActionsToScheduleResult.filter(result => result.actionToLog.uuid && !actionsToNotLog.includes(result.actionToLog.uuid));
    if (!!actionsToLog.length) {
      for (const action of actionsToLog) {
        this.context.alertingEventLogger.logAction(action.actionToLog);
      }
    }
    return {
      throttledSummaryActions
    };
  }
  async runActionAsEphemeralOrAddToBulkScheduleRequest({
    enqueueOptions,
    bulkScheduleRequest
  }) {
    if (this.context.taskRunnerContext.supportsEphemeralTasks && this.ephemeralActionsToSchedule > 0) {
      this.ephemeralActionsToSchedule--;
      try {
        await this.context.actionsClient.ephemeralEnqueuedExecution(enqueueOptions);
      } catch (err) {
        if ((0, _server.isEphemeralTaskRejectedDueToCapacityError)(err)) {
          bulkScheduleRequest.push(enqueueOptions);
        }
      }
    } else {
      bulkScheduleRequest.push(enqueueOptions);
    }
  }
}
exports.ActionScheduler = ActionScheduler;