"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateGapFromSchedule = void 0;
var _constants = require("../../../../common/constants");
var _common = require("../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateGapFromSchedule = ({
  gap,
  backfillSchedule
}) => {
  for (const scheduleItem of backfillSchedule) {
    const runAt = new Date(scheduleItem.runAt).getTime();
    const intervalDuration = (0, _common.parseDuration)(scheduleItem.interval);
    const from = runAt - intervalDuration;
    const to = runAt;
    const scheduleInterval = {
      gte: new Date(from),
      lte: new Date(to)
    };
    if (scheduleItem.status === _constants.adHocRunStatus.PENDING || scheduleItem.status === _constants.adHocRunStatus.RUNNING) {
      gap.addInProgress(scheduleInterval);
    } else if (scheduleItem.status === _constants.adHocRunStatus.COMPLETE) {
      gap.fillGap(scheduleInterval);
    }
  }
  return gap;
};
exports.updateGapFromSchedule = updateGapFromSchedule;