"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calculateGapStateFromAllBackfills = void 0;
var _update_gap_from_schedule = require("./update_gap_from_schedule");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Find all overlapping backfill tasks and update the gap status accordingly
 */
const calculateGapStateFromAllBackfills = async ({
  gap,
  savedObjectsRepository,
  ruleId,
  backfillClient,
  actionsClient
}) => {
  const transformedBackfills = await backfillClient.findOverlappingBackfills({
    ruleId,
    start: gap.range.gte,
    end: gap.range.lte,
    savedObjectsRepository,
    actionsClient
  });
  gap.resetInProgressIntervals();
  for (const backfill of transformedBackfills) {
    var _backfill$schedule;
    if ('error' in backfill) {
      continue;
    }
    gap = (0, _update_gap_from_schedule.updateGapFromSchedule)({
      gap,
      backfillSchedule: (_backfill$schedule = backfill === null || backfill === void 0 ? void 0 : backfill.schedule) !== null && _backfill$schedule !== void 0 ? _backfill$schedule : []
    });
  }
  return gap;
};
exports.calculateGapStateFromAllBackfills = calculateGapStateFromAllBackfills;