"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rangeSchema = exports.rangeListSchema = exports.gapStatusSchema = exports.gapBaseSchema = exports.findGapsSearchAfterParamsSchema = exports.findGapsParamsSchema = exports.findGapsByIdParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const gapStatusSchema = exports.gapStatusSchema = _configSchema.schema.oneOf([_configSchema.schema.literal(_constants.gapStatus.UNFILLED), _configSchema.schema.literal(_constants.gapStatus.FILLED), _configSchema.schema.literal(_constants.gapStatus.PARTIALLY_FILLED)]);
const rangeSchema = exports.rangeSchema = _configSchema.schema.object({
  lte: _configSchema.schema.string(),
  gte: _configSchema.schema.string()
});
const rangeListSchema = exports.rangeListSchema = _configSchema.schema.arrayOf(rangeSchema);
const gapBaseSchema = exports.gapBaseSchema = _configSchema.schema.object({
  status: gapStatusSchema,
  range: rangeSchema,
  in_progress_intervals: rangeListSchema,
  filled_intervals: rangeListSchema,
  unfilled_intervals: rangeListSchema,
  total_gap_duration_ms: _configSchema.schema.number(),
  filled_duration_ms: _configSchema.schema.number(),
  unfilled_duration_ms: _configSchema.schema.number(),
  in_progress_duration_ms: _configSchema.schema.number()
});
const findGapsBaseParamsSchema = _configSchema.schema.object({
  end: _configSchema.schema.string(),
  perPage: _configSchema.schema.number({
    defaultValue: 10,
    min: 0
  }),
  ruleId: _configSchema.schema.string(),
  start: _configSchema.schema.string(),
  sortField: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('@timestamp'), _configSchema.schema.literal('kibana.alert.rule.gap.total_gap_duration_ms'), _configSchema.schema.literal('kibana.alert.rule.gap.status')])),
  sortOrder: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('asc'), _configSchema.schema.literal('desc')])),
  statuses: _configSchema.schema.maybe(_configSchema.schema.arrayOf(gapStatusSchema))
}, {
  validate({
    start,
    end
  }) {
    const parsedStart = Date.parse(start);
    const parsedEnd = Date.parse(end);
    if (isNaN(parsedStart)) {
      return `[start]: query start must be valid date`;
    }
    if (isNaN(parsedEnd)) {
      return `[end]: query end must be valid date`;
    }
    if (parsedStart >= parsedEnd) {
      return `[start]: query start must be before end`;
    }
  }
});
const findGapsParamsSchema = exports.findGapsParamsSchema = findGapsBaseParamsSchema.extends({
  page: _configSchema.schema.number({
    defaultValue: 1,
    min: 1
  })
});
const findGapsByIdParamsSchema = exports.findGapsByIdParamsSchema = _configSchema.schema.object({
  gapIds: _configSchema.schema.arrayOf(_configSchema.schema.string()),
  ruleId: _configSchema.schema.string(),
  page: _configSchema.schema.number({
    defaultValue: 1,
    min: 1
  }),
  perPage: _configSchema.schema.number({
    defaultValue: 10,
    min: 1
  })
});
const findGapsSearchAfterParamsSchema = exports.findGapsSearchAfterParamsSchema = findGapsBaseParamsSchema.extends({
  pitId: _configSchema.schema.maybe(_configSchema.schema.string()),
  searchAfter: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.number(), _configSchema.schema.boolean(), _configSchema.schema.any()])))
});