"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformBackfillParamToAdHocRun = void 0;
var _lodash = require("lodash");
var _lib = require("../../../backfill_client/lib");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformBackfillParamToAdHocRun = (param, rule, actions, spaceId) => {
  const schedule = (0, _lib.calculateSchedule)(param.start, rule.schedule.interval, param.end);
  const shouldRunActions = param.runActions !== undefined ? param.runActions : true;
  return {
    apiKeyId: Buffer.from(rule.apiKey, 'base64').toString().split(':')[0],
    apiKeyToUse: rule.apiKey,
    createdAt: new Date().toISOString(),
    duration: rule.schedule.interval,
    enabled: true,
    end: param.end ? param.end : schedule && schedule.length > 0 ? schedule[0].runAt : undefined,
    rule: {
      name: rule.name,
      tags: rule.tags,
      alertTypeId: rule.alertTypeId,
      params: rule.params,
      apiKeyOwner: rule.apiKeyOwner,
      apiKeyCreatedByUser: rule.apiKeyCreatedByUser,
      actions: shouldRunActions ? actions : [],
      consumer: rule.consumer,
      enabled: rule.enabled,
      schedule: rule.schedule,
      createdBy: rule.createdBy,
      updatedBy: rule.updatedBy,
      createdAt: (0, _lodash.isString)(rule.createdAt) ? rule.createdAt : rule.createdAt.toISOString(),
      updatedAt: (0, _lodash.isString)(rule.updatedAt) ? rule.updatedAt : rule.updatedAt.toISOString(),
      revision: rule.revision
    },
    spaceId,
    start: param.start,
    status: _constants.adHocRunStatus.PENDING,
    schedule
  };
};
exports.transformBackfillParamToAdHocRun = transformBackfillParamToAdHocRun;