"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defineRoute = void 0;
var _constants = require("@kbn/aiops-common/constants");
var _schema = require("@kbn/aiops-log-pattern-analysis/schema");
var _route_handler_factory = require("./route_handler_factory");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defineRoute = (router, license, usageCounter) => {
  router.versioned.post({
    path: _constants.AIOPS_API_ENDPOINT.CATEGORIZATION_FIELD_VALIDATION,
    access: 'internal'
  }).addVersion({
    version: '1',
    security: {
      authz: {
        enabled: false,
        reason: 'This route is opted out from authorization because permissions will be checked by elasticsearch'
      }
    },
    validate: {
      request: {
        body: _schema.categorizationFieldValidationSchema
      }
    }
  }, (0, _route_handler_factory.routeHandlerFactory)(license, usageCounter));
};
exports.defineRoute = defineRoute;