"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAddPatternAnalysisEmbeddableAction = createAddPatternAnalysisEmbeddableAction;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/ui-actions-plugin/public");
var _constants = require("@kbn/aiops-log-pattern-analysis/constants");
var _constants2 = require("@kbn/aiops-common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const parentApiIsCompatible = async parentApi => {
  const {
    apiIsPresentationContainer
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/presentation-containers')));
  // we cannot have an async type check, so return the casted parentApi rather than a boolean
  return apiIsPresentationContainer(parentApi) ? parentApi : undefined;
};
function createAddPatternAnalysisEmbeddableAction(coreStart, pluginStart) {
  return {
    id: 'create-pattern-analysis-embeddable',
    grouping: _constants2.AIOPS_EMBEDDABLE_GROUPING,
    getIconType: () => 'logPatternAnalysis',
    getDisplayName: () => _i18n.i18n.translate('xpack.aiops.embeddablePatternAnalysisDisplayName', {
      defaultMessage: 'Pattern analysis'
    }),
    async isCompatible(context) {
      return Boolean(await parentApiIsCompatible(context.embeddable));
    },
    async execute(context) {
      const presentationContainerParent = await parentApiIsCompatible(context.embeddable);
      if (!presentationContainerParent) throw new _public.IncompatibleActionError();
      try {
        const {
          resolveEmbeddablePatternAnalysisUserInput
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('../embeddables/pattern_analysis/resolve_pattern_analysis_config_input')));
        const initialState = {
          dataViewId: undefined
        };
        const embeddable = await presentationContainerParent.addNewPanel({
          panelType: _constants.EMBEDDABLE_PATTERN_ANALYSIS_TYPE,
          initialState
        });
        if (!embeddable) {
          return;
        }
        const deletePanel = () => {
          presentationContainerParent.removePanel(embeddable.uuid);
        };
        resolveEmbeddablePatternAnalysisUserInput(coreStart, pluginStart, context.embeddable, embeddable.uuid, true, embeddable, deletePanel);
      } catch (e) {
        return Promise.reject();
      }
    }
  };
}