"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AIAssistantManagementPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _ui_setting_keys = require("../common/ui_setting_keys");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
// eslint-disable-next-line @typescript-eslint/no-empty-interface

class AIAssistantManagementPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "kibanaBranch", void 0);
    (0, _defineProperty2.default)(this, "buildFlavor", void 0);
    (0, _defineProperty2.default)(this, "registeredAiAssistantManagementSelectionApp", void 0);
    (0, _defineProperty2.default)(this, "licensingSubscription", void 0);
    this.initializerContext = initializerContext;
    this.kibanaBranch = this.initializerContext.env.packageInfo.branch;
    this.buildFlavor = this.initializerContext.env.packageInfo.buildFlavor;
  }
  setup(core, {
    home,
    management,
    serverless
  }) {
    if (serverless) {
      return {};
    }
    if (home) {
      home.featureCatalogue.register({
        id: 'ai_assistant',
        title: _i18n.i18n.translate('aiAssistantManagementSelection.app.title', {
          defaultMessage: 'AI Assistants'
        }),
        description: _i18n.i18n.translate('aiAssistantManagementSelection.app.description', {
          defaultMessage: 'Manage your AI Assistants.'
        }),
        icon: 'sparkles',
        path: '/app/management/kibana/aiAssistantManagementSelection',
        showOnHomePage: false,
        category: 'admin'
      });
    }
    this.registeredAiAssistantManagementSelectionApp = management.sections.section.kibana.registerApp({
      id: 'aiAssistantManagementSelection',
      title: _i18n.i18n.translate('aiAssistantManagementSelection.managementSectionLabel', {
        defaultMessage: 'AI Assistants'
      }),
      order: 1,
      mount: async mountParams => {
        const {
          mountManagementSection
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./management_section/mount_section')));
        return mountManagementSection({
          core,
          mountParams,
          kibanaBranch: this.kibanaBranch,
          buildFlavor: this.buildFlavor
        });
      }
    });

    // Default to disabled until license check runs in start()
    this.registeredAiAssistantManagementSelectionApp.disable();
    return {};
  }
  start(coreStart, {
    licensing
  }) {
    const preferredAIAssistantType = coreStart.uiSettings.get(_ui_setting_keys.PREFERRED_AI_ASSISTANT_TYPE_SETTING_KEY);
    const aiAssistantType$ = new _rxjs.BehaviorSubject(preferredAIAssistantType);
    const isAiAssistantManagementSelectionEnabled = coreStart.application.capabilities.management.kibana.aiAssistantManagementSelection;

    // Toggle visibility based on license at runtime
    if (licensing) {
      this.licensingSubscription = licensing.license$.subscribe(license => {
        const isEnterprise = license === null || license === void 0 ? void 0 : license.hasAtLeast('enterprise');
        if (isEnterprise && isAiAssistantManagementSelectionEnabled) {
          var _this$registeredAiAss;
          (_this$registeredAiAss = this.registeredAiAssistantManagementSelectionApp) === null || _this$registeredAiAss === void 0 ? void 0 : _this$registeredAiAss.enable();
        } else {
          var _this$registeredAiAss2;
          (_this$registeredAiAss2 = this.registeredAiAssistantManagementSelectionApp) === null || _this$registeredAiAss2 === void 0 ? void 0 : _this$registeredAiAss2.disable();
        }
      });
    }
    return {
      aiAssistantType$: aiAssistantType$.asObservable()
    };
  }
  stop() {
    var _this$licensingSubscr;
    (_this$licensingSubscr = this.licensingSubscription) === null || _this$licensingSubscr === void 0 ? void 0 : _this$licensingSubscr.unsubscribe();
  }
}
exports.AIAssistantManagementPlugin = AIAssistantManagementPlugin;