"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.components = void 0;
var _utils = require("../../../../services/theme/utils");
var _manipulation = require("../../../../services/color/manipulation");
var _contrast = require("../../../../services/color/contrast");
var _buttons = require("./_buttons");
var _forms = require("./_forms");
var _colors_vis = require("./_colors_vis");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var component_colors = {
  badgeBackground: (0, _utils.computed)(function (_ref) {
    var _ref2 = _slicedToArray(_ref, 1),
      lightShade = _ref2[0];
    return lightShade;
  }, ['colors.lightShade']),
  badgeBackgroundSubdued: (0, _utils.computed)(function (_ref3) {
    var _ref4 = _slicedToArray(_ref3, 1),
      lightShade = _ref4[0];
    return (0, _manipulation.tint)(lightShade, 0.3);
  }, ['colors.lightShade']),
  badgeBorderColorHollow: (0, _utils.computed)(function (_ref5) {
    var _ref6 = _slicedToArray(_ref5, 1),
      color = _ref6[0];
    return color;
  }, ['border.color']),
  badgeIconButtonBackgroundHover: (0, _utils.computed)(function (_ref7) {
    var _ref8 = _slicedToArray(_ref7, 1),
      ghost = _ref8[0];
    return (0, _manipulation.transparentize)(ghost, 0.8);
  }, ['colors.ghost']),
  breadcrumbsApplicationBackground: (0, _utils.computed)(function (_ref9) {
    var _ref10 = _slicedToArray(_ref9, 1),
      darkestShade = _ref10[0];
    return (0, _manipulation.tint)(darkestShade, 0.85);
  }, ['colors.darkestShade']),
  breadcrumbsApplicationColor: (0, _utils.computed)(function (_ref11) {
    var _ref12 = _slicedToArray(_ref11, 1),
      darkestShade = _ref12[0];
    return (0, _manipulation.tint)(darkestShade, 0.2);
  }, ['colors.darkestShade']),
  buttonGroupBorderColor: (0, _utils.computed)(function (_ref13) {
    var _ref14 = _slicedToArray(_ref13, 1),
      fullShade = _ref14[0];
    return (0, _manipulation.transparentize)(fullShade, 0.1);
  }, ['colors.fullShade']),
  buttonGroupBorderColorSelected: (0, _utils.computed)(function (_ref15) {
    var _ref16 = _slicedToArray(_ref15, 1),
      emptyShade = _ref16[0];
    return (0, _manipulation.transparentize)(emptyShade, 0.2);
  }, ['colors.emptyShade']),
  buttonGroupFocusColor: (0, _utils.computed)(function (_ref17) {
    var _ref18 = _slicedToArray(_ref17, 1),
      fullShade = _ref18[0];
    return fullShade;
  }, ['colors.fullShade']),
  bottomBarBackground: (0, _utils.computed)(function (_ref19) {
    var _ref20 = _slicedToArray(_ref19, 1),
      lightestShade = _ref20[0];
    return (0, _manipulation.shade)(lightestShade, 0.5);
  }, ['colors.lightestShade']),
  codeBackground: (0, _utils.computed)(function (_ref21) {
    var _ref22 = _slicedToArray(_ref21, 1),
      lightestShade = _ref22[0];
    return lightestShade;
  }, ['colors.lightestShade']),
  codeBackgroundSelected: 'inherit',
  codeColor: (0, _utils.computed)(function (_ref23) {
    var _ref24 = _slicedToArray(_ref23, 2),
      lightestShade = _ref24[0],
      text = _ref24[1];
    return (0, _contrast.makeHighContrastColor)(text)(lightestShade);
  }, ['colors.lightestShade', 'colors.text']),
  codeInlineColor: (0, _utils.computed)(function (_ref25) {
    var _ref26 = _slicedToArray(_ref25, 1),
      lightestShade = _ref26[0];
    return (0, _contrast.makeHighContrastColor)(_colors_vis.colorVis.euiColorVis3)(lightestShade);
  }, ['colors.lightestShade']),
  codeCommentColor: (0, _utils.computed)(function (_ref27) {
    var _ref28 = _slicedToArray(_ref27, 2),
      lightestShade = _ref28[0],
      subduedText = _ref28[1];
    return (0, _contrast.makeHighContrastColor)(subduedText)(lightestShade);
  }, ['colors.lightestShade', 'colors.subduedText']),
  codeSelectorColor: 'inherit',
  codeStringColor: (0, _utils.computed)(function (_ref29) {
    var _ref30 = _slicedToArray(_ref29, 1),
      lightestShade = _ref30[0];
    return (0, _contrast.makeHighContrastColor)(_colors_vis.colorVis.euiColorVis2)(lightestShade);
  }, ['colors.lightestShade']),
  codeTagColor: (0, _utils.computed)(function (_ref31) {
    var _ref32 = _slicedToArray(_ref31, 1),
      lightestShade = _ref32[0];
    return (0, _contrast.makeHighContrastColor)(_colors_vis.colorVis.euiColorVis1)(lightestShade);
  }, ['colors.lightestShade']),
  codeNameColor: (0, _utils.computed)(function (_ref33) {
    var _ref34 = _slicedToArray(_ref33, 1),
      lightestShade = _ref34[0];
    return (0, _contrast.makeHighContrastColor)(_colors_vis.colorVis.euiColorVis1)(lightestShade);
  }, ['colors.lightestShade']),
  codeNumberColor: (0, _utils.computed)(function (_ref35) {
    var _ref36 = _slicedToArray(_ref35, 1),
      lightestShade = _ref36[0];
    return (0, _contrast.makeHighContrastColor)(_colors_vis.colorVis.euiColorVis0)(lightestShade);
  }, ['colors.lightestShade']),
  codeKeywordColor: (0, _utils.computed)(function (_ref37) {
    var _ref38 = _slicedToArray(_ref37, 1),
      lightestShade = _ref38[0];
    return (0, _contrast.makeHighContrastColor)(_colors_vis.colorVis.euiColorVis3)(lightestShade);
  }, ['colors.lightestShade']),
  codeFunctionTitleColor: 'inherit',
  codeTypeColor: (0, _utils.computed)(function (_ref39) {
    var _ref40 = _slicedToArray(_ref39, 1),
      lightestShade = _ref40[0];
    return (0, _contrast.makeHighContrastColor)(_colors_vis.colorVis.euiColorVis1)(lightestShade);
  }, ['colors.lightestShade']),
  codeAttributeColor: 'inherit',
  codeSymbolColor: (0, _utils.computed)(function (_ref41) {
    var _ref42 = _slicedToArray(_ref41, 1),
      lightestShade = _ref42[0];
    return (0, _contrast.makeHighContrastColor)(_colors_vis.colorVis.euiColorVis9)(lightestShade);
  }, ['colors.lightestShade']),
  codeParamsColor: 'inherit',
  codeMetaColor: (0, _utils.computed)(function (_ref43) {
    var _ref44 = _slicedToArray(_ref43, 2),
      lightestShade = _ref44[0],
      subduedText = _ref44[1];
    return (0, _contrast.makeHighContrastColor)(subduedText)(lightestShade);
  }, ['colors.lightestShade', 'colors.subduedText']),
  codeTitleColor: (0, _utils.computed)(function (_ref45) {
    var _ref46 = _slicedToArray(_ref45, 1),
      lightestShade = _ref46[0];
    return (0, _contrast.makeHighContrastColor)(_colors_vis.colorVis.euiColorVis7)(lightestShade);
  }, ['colors.lightestShade']),
  codeSectionColor: (0, _utils.computed)(function (_ref47) {
    var _ref48 = _slicedToArray(_ref47, 1),
      lightestShade = _ref48[0];
    return (0, _contrast.makeHighContrastColor)(_colors_vis.colorVis.euiColorVis9)(lightestShade);
  }, ['colors.lightestShade']),
  codeAdditionColor: (0, _utils.computed)(function (_ref49) {
    var _ref50 = _slicedToArray(_ref49, 1),
      lightestShade = _ref50[0];
    return (0, _contrast.makeHighContrastColor)(_colors_vis.colorVis.euiColorVis0)(lightestShade);
  }, ['colors.lightestShade']),
  codeDeletionColor: (0, _utils.computed)(function (_ref51) {
    var _ref52 = _slicedToArray(_ref51, 2),
      lightestShade = _ref52[0],
      danger = _ref52[1];
    return (0, _contrast.makeHighContrastColor)(danger)(lightestShade);
  }, ['colors.lightestShade', 'colors.danger']),
  codeSelectorClassColor: 'inherit',
  codeSelectorIdColor: 'inherit',
  collapsibleNavGroupBackground: (0, _utils.computed)(function (_ref53) {
    var _ref54 = _slicedToArray(_ref53, 1),
      body = _ref54[0];
    return body;
  }, ['colors.body']),
  collapsibleNavGroupBackgroundDark: (0, _utils.computed)(function (_ref55) {
    var _ref56 = _slicedToArray(_ref55, 1),
      darkestShade = _ref56[0];
    return (0, _manipulation.shade)(darkestShade, 0.2);
  }, ['colors.darkestShade']),
  dataGridBorderColor: (0, _utils.computed)(function (_ref57) {
    var _ref58 = _slicedToArray(_ref57, 1),
      color = _ref58[0];
    return color;
  }, ['border.color']),
  dataGridVerticalLineBorderColor: (0, _utils.computed)(function (_ref59) {
    var _ref60 = _slicedToArray(_ref59, 1),
      color = _ref60[0];
    return (0, _manipulation.tint)(color, 0.3);
  }, ['border.color']),
  dataGridRowBackgroundStriped: (0, _utils.computed)(function (_ref61) {
    var _ref62 = _slicedToArray(_ref61, 1),
      lightestShade = _ref62[0];
    return lightestShade;
  }, ['colors.lightestShade']),
  dataGridRowBackgroundHover: (0, _utils.computed)(function (_ref63) {
    var _ref64 = _slicedToArray(_ref63, 1),
      highlight = _ref64[0];
    return highlight;
  }, ['colors.highlight']),
  dataGridRowBackgroundSelect: (0, _utils.computed)(function (_ref65) {
    var _ref66 = _slicedToArray(_ref65, 1),
      highlight = _ref66[0];
    return highlight;
  }, ['colors.highlight']),
  dragDropDraggingBackground: (0, _utils.computed)(function (_ref67) {
    var _ref68 = _slicedToArray(_ref67, 1),
      success = _ref68[0];
    return (0, _manipulation.transparentize)(success, 0.1);
  }, ['colors.success']),
  dragDropDraggingOverBackground: (0, _utils.computed)(function (_ref69) {
    var _ref70 = _slicedToArray(_ref69, 1),
      success = _ref70[0];
    return (0, _manipulation.transparentize)(success, 0.25);
  }, ['colors.success']),
  filterSelectItemBackgroundFocusDisabled: (0, _utils.computed)(function (_ref71) {
    var _ref72 = _slicedToArray(_ref71, 1),
      disabled = _ref72[0];
    return (0, _manipulation.transparentize)(disabled, 0.1);
  }, ['colors.disabled']),
  flyoutFooterBackground: (0, _utils.computed)(function (_ref73) {
    var _ref74 = _slicedToArray(_ref73, 1),
      lightestShade = _ref74[0];
    return lightestShade;
  }, ['colors.lightestShade']),
  flyoutCloseButtonInsideBackground: (0, _utils.computed)(function (_ref75) {
    var _ref76 = _slicedToArray(_ref75, 1),
      emptyShade = _ref76[0];
    return (0, _manipulation.transparentize)(emptyShade, 0.9);
  }, ['colors.emptyShade']),
  headerBackground: (0, _utils.computed)(function (_ref77) {
    var _ref78 = _slicedToArray(_ref77, 1),
      emptyShade = _ref78[0];
    return emptyShade;
  }, ['colors.emptyShade']),
  headerDarkBackground: (0, _utils.computed)(function (_ref79) {
    var _ref80 = _slicedToArray(_ref79, 1),
      darkestShade = _ref80[0];
    return (0, _manipulation.shade)(darkestShade, 0.28);
  }, ['colors.darkestShade']),
  headerDarkSearchBorderColor: (0, _utils.computed)(function (_ref81) {
    var _ref82 = _slicedToArray(_ref81, 1),
      ghost = _ref82[0];
    return (0, _manipulation.transparentize)(ghost, 0.3);
  }, ['colors.ghost']),
  headerDarkSectionItemBackgroundFocus: (0, _utils.computed)(function (_ref83) {
    var _ref84 = _slicedToArray(_ref83, 1),
      primary = _ref84[0];
    return (0, _manipulation.shade)(primary, 0.5);
  }, ['colors.primary']),
  keyPadMenuItemBackgroundDisabledSelect: (0, _utils.computed)(function (_ref85) {
    var _ref86 = _slicedToArray(_ref85, 1),
      disabled = _ref86[0];
    return (0, _manipulation.transparentize)(disabled, 0.1);
  }, ['colors.disabled']),
  listGroupItemBackgroundPrimaryActive: (0, _utils.computed)(function (_ref87) {
    var _ref88 = _slicedToArray(_ref87, 1),
      lightShade = _ref88[0];
    return (0, _manipulation.transparentize)(lightShade, 0.2);
  }, ['colors.lightShade']),
  listGroupItemBackgroundSubduedActive: (0, _utils.computed)(function (_ref89) {
    var _ref90 = _slicedToArray(_ref89, 1),
      primary = _ref90[0];
    return (0, _manipulation.transparentize)(primary, 0.1);
  }, ['colors.primary']),
  listGroupItemBackgroundHover: (0, _utils.computed)(function (_ref91) {
    var _ref92 = _slicedToArray(_ref91, 1),
      lightShade = _ref92[0];
    return (0, _manipulation.transparentize)(lightShade, 0.2);
  }, ['colors.lightShade']),
  listGroupItemBackgroundPrimaryHover: (0, _utils.computed)(function (_ref93) {
    var _ref94 = _slicedToArray(_ref93, 1),
      primary = _ref94[0];
    return (0, _manipulation.transparentize)(primary, 0.1);
  }, ['colors.primary']),
  loadingChartMonoBackground0: (0, _utils.computed)(function (_ref95) {
    var _ref96 = _slicedToArray(_ref95, 1),
      lightShade = _ref96[0];
    return lightShade;
  }, ['colors.lightShade']),
  loadingChartMonoBackground1: (0, _utils.computed)(function (_ref97) {
    var _ref98 = _slicedToArray(_ref97, 1),
      lightShade = _ref98[0];
    return (0, _manipulation.shade)(lightShade, 0.04);
  }, ['colors.lightShade']),
  loadingChartMonoBackground2: (0, _utils.computed)(function (_ref99) {
    var _ref100 = _slicedToArray(_ref99, 1),
      lightShade = _ref100[0];
    return (0, _manipulation.shade)(lightShade, 0.08);
  }, ['colors.lightShade']),
  loadingChartMonoBackground3: (0, _utils.computed)(function (_ref101) {
    var _ref102 = _slicedToArray(_ref101, 1),
      lightShade = _ref102[0];
    return (0, _manipulation.shade)(lightShade, 0.12);
  }, ['colors.lightShade']),
  markBackground: (0, _utils.computed)(function (_ref103) {
    var _ref104 = _slicedToArray(_ref103, 1),
      primary = _ref104[0];
    return (0, _manipulation.transparentize)(primary, 0.1);
  }, ['colors.primary']),
  markdownFormatTableBorderColor: (0, _utils.computed)(function (_ref105) {
    var _ref106 = _slicedToArray(_ref105, 1),
      fullShade = _ref106[0];
    return (0, _manipulation.transparentize)(fullShade, 0.15);
  }, ['colors.fullShade']),
  popoverPanelBackground: (0, _utils.computed)(function (_ref107) {
    var _ref108 = _slicedToArray(_ref107, 1),
      emptyShade = _ref108[0];
    return emptyShade;
  }, ['colors.emptyShade']),
  popoverFooterBorderColor: (0, _utils.computed)(function (_ref109) {
    var _ref110 = _slicedToArray(_ref109, 1),
      color = _ref110[0];
    return color;
  }, ['border.color']),
  scrollbarTrackColor: (0, _utils.computed)(function (_ref111) {
    var _ref112 = _slicedToArray(_ref111, 1),
      body = _ref112[0];
    return (0, _manipulation.shade)(body, 0.03);
  }, ['colors.body']),
  sideNavItemEmphasizedBackground: (0, _utils.computed)(function (_ref113) {
    var _ref114 = _slicedToArray(_ref113, 1),
      lightShade = _ref114[0];
    return (0, _manipulation.transparentize)(lightShade, 0.3);
  }, ['colors.lightShade']),
  selectableListItemBorderColor: (0, _utils.computed)(function (_ref115) {
    var _ref116 = _slicedToArray(_ref115, 1),
      color = _ref116[0];
    return (0, _manipulation.transparentize)(color, 0.4);
  }, ['border.color']),
  superDatePickerBackgroundSuccees: (0, _utils.computed)(function (_ref117) {
    var _ref118 = _slicedToArray(_ref117, 1),
      success = _ref118[0];
    return (0, _manipulation.tint)(success, 0.9);
  }, ['colors.success']),
  switchBackgroundOn: (0, _utils.computed)(function (_ref119) {
    var _ref120 = _slicedToArray(_ref119, 1),
      primary = _ref120[0];
    return primary;
  }, ['colors.primary']),
  switchBackgroundOff: (0, _utils.computed)(function (_ref121) {
    var _ref122 = _slicedToArray(_ref121, 1),
      lightestShade = _ref122[0];
    return (0, _manipulation.shade)(lightestShade, 0.4);
  }, ['colors.lightestShade']),
  switchUncompressedBackgroundDisabled: (0, _utils.computed)(function (_ref123) {
    var _ref124 = _slicedToArray(_ref123, 1),
      lightShade = _ref124[0];
    return (0, _manipulation.tint)(lightShade, 0.5);
  }, ['colors.lightShade']),
  switchCompressedBackgroundDisabled: (0, _utils.computed)(function (_ref125) {
    var _ref126 = _slicedToArray(_ref125, 1),
      lightShade = _ref126[0];
    return (0, _manipulation.tint)(lightShade, 0.25);
  }, ['colors.lightShade']),
  switchMiniBackgroundDisabled: (0, _utils.computed)(function (_ref127) {
    var _ref128 = _slicedToArray(_ref127, 1),
      lightShade = _ref128[0];
    return (0, _manipulation.tint)(lightShade, 0);
  }, ['colors.lightShade']),
  switchThumbBackgroundDisabled: 'transparent',
  switchThumbBorderOn: (0, _utils.computed)(function (_ref129) {
    var _ref130 = _slicedToArray(_ref129, 1),
      lightestShade = _ref130[0];
    return (0, _manipulation.shade)(lightestShade, 0.4);
  }, ['colors.lightestShade']),
  switchThumbBorderOff: (0, _utils.computed)(function (_ref131) {
    var _ref132 = _slicedToArray(_ref131, 1),
      lightestShade = _ref132[0];
    return (0, _manipulation.shade)(lightestShade, 0.4);
  }, ['colors.lightestShade']),
  switchIconDisabled: (0, _utils.computed)(function (_ref133) {
    var _ref134 = _slicedToArray(_ref133, 1),
      lightestShade = _ref134[0];
    return (0, _manipulation.shade)(lightestShade, 0.4);
  }, ['colors.lightestShade']),
  tableRowBackgroundHover: (0, _utils.computed)(function (_ref135) {
    var _ref136 = _slicedToArray(_ref135, 1),
      lightestShade = _ref136[0];
    return (0, _manipulation.tint)(lightestShade, 0.5);
  }, ['colors.lightestShade']),
  tableRowBackgroundSelected: (0, _utils.computed)(function (_ref137) {
    var _ref138 = _slicedToArray(_ref137, 1),
      primary = _ref138[0];
    return (0, _manipulation.tint)(primary, 0.96);
  }, ['colors.primary']),
  tableRowBackgroundSelectedHover: (0, _utils.computed)(function (_ref139) {
    var _ref140 = _slicedToArray(_ref139, 1),
      primary = _ref140[0];
    return (0, _manipulation.tint)(primary, 0.9);
  }, ['colors.primary']),
  tableRowInteractiveBackgroundHover: (0, _utils.computed)(function (_ref141) {
    var _ref142 = _slicedToArray(_ref141, 1),
      primary = _ref142[0];
    return (0, _manipulation.transparentize)(primary, 0.05);
  }, ['colors.primary']),
  tableRowInteractiveBackgroundFocus: (0, _utils.computed)(function (_ref143) {
    var _ref144 = _slicedToArray(_ref143, 1),
      primary = _ref144[0];
    return (0, _manipulation.transparentize)(primary, 0.1);
  }, ['colors.primary']),
  tableCellSortableIconColor: (0, _utils.computed)(function (_ref145) {
    var _ref146 = _slicedToArray(_ref145, 2),
      emptyShade = _ref146[0],
      subduedText = _ref146[1];
    var color = (0, _manipulation.tint)(subduedText, 0.9);
    return (0, _contrast.makeHighContrastColor)(
    // Tint it arbitrarily high, the contrast util will take care of lowering back down to WCAG
    color, 3 // 3:1 ratio from https://www.w3.org/WAI/WCAG22/Understanding/non-text-contrast.html
    )(emptyShade);
  }, ['colors.emptyShade', 'colors.subduedText']),
  tooltipBackground: (0, _utils.computed)(function (_ref147) {
    var _ref148 = _slicedToArray(_ref147, 1),
      fullShade = _ref148[0];
    return (0, _manipulation.tint)(fullShade, 0.25);
  }, ['colors.fullShade']),
  tooltipBorder: (0, _utils.computed)(function (_ref149) {
    var _ref150 = _slicedToArray(_ref149, 1),
      fullShade = _ref150[0];
    return (0, _manipulation.tint)(fullShade, 0.35);
  }, ['colors.fullShade']),
  tooltipBorderFloating: (0, _utils.computed)(function (_ref151) {
    var _ref152 = _slicedToArray(_ref151, 1),
      borderBaseFloating = _ref152[0];
    return borderBaseFloating;
  }, ['colors.borderBaseFloating']),
  tourFooterBackground: (0, _utils.computed)(function (_ref153) {
    var _ref154 = _slicedToArray(_ref153, 1),
      lightestShade = _ref154[0];
    return (0, _manipulation.tint)(lightestShade, 0.5);
  }, ['colors.lightestShade']),
  treeViewItemBackgroundHover: (0, _utils.computed)(function (_ref155) {
    var _ref156 = _slicedToArray(_ref155, 1),
      text = _ref156[0];
    return (0, _manipulation.transparentize)(text, 0.1);
  }, ['colors.text'])
};
var components = exports.components = {
  buttons: _buttons.buttons,
  forms: _forms.forms,
  LIGHT: component_colors,
  DARK: _objectSpread(_objectSpread({}, component_colors), {}, {
    badgeBorderColorHollow: (0, _utils.computed)(function (_ref157) {
      var _ref158 = _slicedToArray(_ref157, 1),
        color = _ref158[0];
      return (0, _manipulation.tint)(color, 0.15);
    }, ['border.color']),
    breadcrumbsApplicationBackground: (0, _utils.computed)(function (_ref159) {
      var _ref160 = _slicedToArray(_ref159, 1),
        darkestShade = _ref160[0];
      return (0, _manipulation.shade)(darkestShade, 0.7);
    }, ['colors.darkestShade']),
    breadcrumbsApplicationColor: (0, _utils.computed)(function (_ref161) {
      var _ref162 = _slicedToArray(_ref161, 1),
        darkestShade = _ref162[0];
      return (0, _manipulation.shade)(darkestShade, 0.2);
    }, ['colors.darkestShade']),
    collapsibleNavGroupBackground: (0, _utils.computed)(function (_ref163) {
      var _ref164 = _slicedToArray(_ref163, 1),
        lightestShade = _ref164[0];
      return (0, _manipulation.shade)(lightestShade, 0.5);
    }, ['colors.lightestShade']),
    collapsibleNavGroupBackgroundDark: (0, _utils.computed)(function (_ref165) {
      var _ref166 = _slicedToArray(_ref165, 1),
        lightestShade = _ref166[0];
      return (0, _manipulation.shade)(lightestShade, 0.5);
    }, ['colors.lightestShade']),
    dataGridVerticalLineBorderColor: (0, _utils.computed)(function (_ref167) {
      var _ref168 = _slicedToArray(_ref167, 1),
        color = _ref168[0];
      return (0, _manipulation.shade)(color, 0.3);
    }, ['border.color']),
    headerDarkBackground: (0, _utils.computed)(function (_ref169) {
      var _ref170 = _slicedToArray(_ref169, 1),
        lightestShade = _ref170[0];
      return (0, _manipulation.shade)(lightestShade, 0.5);
    }, ['colors.lightestShade']),
    keyPadMenuItemBackgroundDisabledSelect: (0, _utils.computed)(function (_ref171) {
      var _ref172 = _slicedToArray(_ref171, 1),
        disabled = _ref172[0];
      return (0, _manipulation.transparentize)(disabled, 0.2);
    }, ['colors.disabled']),
    listGroupItemBackgroundSubduedActive: (0, _utils.computed)(function (_ref173) {
      var _ref174 = _slicedToArray(_ref173, 1),
        lightShade = _ref174[0];
      return (0, _manipulation.transparentize)(lightShade, 0.4);
    }, ['colors.lightShade']),
    loadingChartMonoBackground0: (0, _utils.computed)(function (_ref175) {
      var _ref176 = _slicedToArray(_ref175, 1),
        lightShade = _ref176[0];
      return lightShade;
    }, ['colors.lightShade']),
    loadingChartMonoBackground1: (0, _utils.computed)(function (_ref177) {
      var _ref178 = _slicedToArray(_ref177, 1),
        lightShade = _ref178[0];
      return (0, _manipulation.tint)(lightShade, 0.04);
    }, ['colors.lightShade']),
    loadingChartMonoBackground2: (0, _utils.computed)(function (_ref179) {
      var _ref180 = _slicedToArray(_ref179, 1),
        lightShade = _ref180[0];
      return (0, _manipulation.tint)(lightShade, 0.08);
    }, ['colors.lightShade']),
    loadingChartMonoBackground3: (0, _utils.computed)(function (_ref181) {
      var _ref182 = _slicedToArray(_ref181, 1),
        lightShade = _ref182[0];
      return (0, _manipulation.tint)(lightShade, 0.12);
    }, ['colors.lightShade']),
    markBackground: (0, _utils.computed)(function (_ref183) {
      var _ref184 = _slicedToArray(_ref183, 1),
        primary = _ref184[0];
      return (0, _manipulation.transparentize)(primary, 0.3);
    }, ['colors.primary']),
    popoverPanelBackground: (0, _utils.computed)(function (_ref185) {
      var _ref186 = _slicedToArray(_ref185, 1),
        emptyShade = _ref186[0];
      return (0, _manipulation.tint)(emptyShade, 0.025);
    }, ['colors.emptyShade']),
    scrollbarTrackColor: (0, _utils.computed)(function (_ref187) {
      var _ref188 = _slicedToArray(_ref187, 1),
        body = _ref188[0];
      return (0, _manipulation.tint)(body, 0.07);
    }, ['colors.body']),
    superDatePickerBackgroundSuccees: (0, _utils.computed)(function (_ref189) {
      var _ref190 = _slicedToArray(_ref189, 1),
        success = _ref190[0];
      return (0, _manipulation.shade)(success, 0.7);
    }, ['colors.success']),
    switchBackgroundOff: (0, _utils.computed)(function (_ref191) {
      var _ref192 = _slicedToArray(_ref191, 1),
        lightestShade = _ref192[0];
      return (0, _manipulation.tint)(lightestShade, 0.31);
    }, ['colors.lightestShade']),
    switchUncompressedBackgroundDisabled: (0, _utils.computed)(function (_ref193) {
      var _ref194 = _slicedToArray(_ref193, 1),
        lightShade = _ref194[0];
      return lightShade;
    }, ['colors.lightShade']),
    switchCompressedBackgroundDisabled: (0, _utils.computed)(function (_ref195) {
      var _ref196 = _slicedToArray(_ref195, 1),
        lightShade = _ref196[0];
      return lightShade;
    }, ['colors.lightShade']),
    switchMiniBackgroundDisabled: (0, _utils.computed)(function (_ref197) {
      var _ref198 = _slicedToArray(_ref197, 1),
        lightShade = _ref198[0];
      return lightShade;
    }, ['colors.lightShade']),
    switchThumbBorderOn: (0, _utils.computed)(function (_ref199) {
      var _ref200 = _slicedToArray(_ref199, 1),
        lightestShade = _ref200[0];
      return (0, _manipulation.tint)(lightestShade, 0.31);
    }, ['colors.lightestShade']),
    switchThumbBorderOff: (0, _utils.computed)(function (_ref201) {
      var _ref202 = _slicedToArray(_ref201, 1),
        lightestShade = _ref202[0];
      return (0, _manipulation.tint)(lightestShade, 0.31);
    }, ['colors.lightestShade']),
    switchIconDisabled: (0, _utils.computed)(function (_ref203) {
      var _ref204 = _slicedToArray(_ref203, 1),
        lightestShade = _ref204[0];
      return (0, _manipulation.tint)(lightestShade, 0.31);
    }, ['colors.lightestShade']),
    tableRowBackgroundHover: (0, _utils.computed)(function (_ref205) {
      var _ref206 = _slicedToArray(_ref205, 1),
        lightestShade = _ref206[0];
      return lightestShade;
    }, ['colors.lightestShade']),
    tableRowBackgroundSelected: (0, _utils.computed)(function (_ref207) {
      var _ref208 = _slicedToArray(_ref207, 1),
        primary = _ref208[0];
      return (0, _manipulation.shade)(primary, 0.7);
    }, ['colors.primary']),
    tableRowBackgroundSelectedHover: (0, _utils.computed)(function (_ref209) {
      var _ref210 = _slicedToArray(_ref209, 1),
        primary = _ref210[0];
      return (0, _manipulation.shade)(primary, 0.75);
    }, ['colors.primary']),
    tableCellSortableIconColor: (0, _utils.computed)(function (_ref211) {
      var _ref212 = _slicedToArray(_ref211, 2),
        emptyShade = _ref212[0],
        subduedText = _ref212[1];
      var color = (0, _manipulation.shade)(subduedText, 0.9);
      return (0, _contrast.makeHighContrastColor)(color, 3)(emptyShade);
    }, ['colors.emptyShade', 'colors.subduedText']),
    tooltipBackground: (0, _utils.computed)(function (_ref213) {
      var _ref214 = _slicedToArray(_ref213, 1),
        emptyShade = _ref214[0];
      return (0, _manipulation.shade)(emptyShade, 1);
    }, ['colors.emptyShade']),
    tooltipBorder: (0, _utils.computed)(function (_ref215) {
      var _ref216 = _slicedToArray(_ref215, 1),
        fullShade = _ref216[0];
      return (0, _manipulation.shade)(fullShade, 0.8);
    }, ['colors.fullShade']),
    tourFooterBackground: (0, _utils.computed)(function (_ref217) {
      var _ref218 = _slicedToArray(_ref217, 1),
        lightestShade = _ref218[0];
      return (0, _manipulation.shade)(lightestShade, 0.45);
    }, ['colors.lightestShade']),
    treeViewItemBackgroundHover: (0, _utils.computed)(function (_ref219) {
      var _ref220 = _slicedToArray(_ref219, 1),
        text = _ref220[0];
      return (0, _manipulation.transparentize)(text, 0.2);
    }, ['colors.text'])
  })
};