"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buttons = void 0;
var _euiThemeCommon = require("@elastic/eui-theme-common");
var _hex_to_rgb = require("../../../../services/color/hex_to_rgb");
var _is_color_dark = require("../../../../services/color/is_color_dark");
var _manipulation = require("../../../../services/color/manipulation");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var isDark = function isDark(background) {
  return background ? _is_color_dark.isColorDark.apply(void 0, _toConsumableArray((0, _hex_to_rgb.hexToRgb)(background))) : false;
};
var _buttons = {
  backgroundPrimary: (0, _euiThemeCommon.computed)(function (_ref) {
    var _ref2 = _slicedToArray(_ref, 1),
      backgroundLightPrimary = _ref2[0];
    return backgroundLightPrimary;
  }, ['colors.backgroundLightPrimary']),
  backgroundAccent: (0, _euiThemeCommon.computed)(function (_ref3) {
    var _ref4 = _slicedToArray(_ref3, 1),
      backgroundLightAccent = _ref4[0];
    return backgroundLightAccent;
  }, ['colors.backgroundLightAccent']),
  backgroundAccentSecondary: (0, _euiThemeCommon.computed)(function (_ref5) {
    var _ref6 = _slicedToArray(_ref5, 1),
      backgroundLightAccentSecondary = _ref6[0];
    return backgroundLightAccentSecondary;
  }, ['colors.backgroundLightAccentSecondary']),
  backgroundSuccess: (0, _euiThemeCommon.computed)(function (_ref7) {
    var _ref8 = _slicedToArray(_ref7, 1),
      backgroundLightSuccess = _ref8[0];
    return backgroundLightSuccess;
  }, ['colors.backgroundLightSuccess']),
  backgroundWarning: (0, _euiThemeCommon.computed)(function (_ref9) {
    var _ref10 = _slicedToArray(_ref9, 1),
      backgroundLightWarning = _ref10[0];
    return backgroundLightWarning;
  }, ['colors.backgroundLightWarning']),
  backgroundDanger: (0, _euiThemeCommon.computed)(function (_ref11) {
    var _ref12 = _slicedToArray(_ref11, 1),
      backgroundLightDanger = _ref12[0];
    return backgroundLightDanger;
  }, ['colors.backgroundLightDanger']),
  backgroundText: (0, _euiThemeCommon.computed)(function (_ref13) {
    var _ref14 = _slicedToArray(_ref13, 1),
      backgroundLightText = _ref14[0];
    return backgroundLightText;
  }, ['colors.backgroundLightText']),
  backgroundDisabled: (0, _euiThemeCommon.computed)(function (_ref15) {
    var _ref16 = _slicedToArray(_ref15, 1),
      lightShade = _ref16[0];
    return (0, _manipulation.transparentize)(lightShade, 0.15);
  }, ['colors.lightShade']),
  backgroundFilledPrimary: (0, _euiThemeCommon.computed)(function (_ref17) {
    var _ref18 = _slicedToArray(_ref17, 1),
      backgroundFilledPrimary = _ref18[0];
    return backgroundFilledPrimary;
  }, ['colors.backgroundFilledPrimary']),
  backgroundFilledAccent: (0, _euiThemeCommon.computed)(function (_ref19) {
    var _ref20 = _slicedToArray(_ref19, 1),
      backgroundFilledAccent = _ref20[0];
    return backgroundFilledAccent;
  }, ['colors.backgroundFilledAccent']),
  backgroundFilledAccentSecondary: (0, _euiThemeCommon.computed)(function (_ref21) {
    var _ref22 = _slicedToArray(_ref21, 1),
      backgroundFilledAccent = _ref22[0];
    return backgroundFilledAccent;
  }, ['colors.backgroundFilledAccent']),
  backgroundFilledSuccess: (0, _euiThemeCommon.computed)(function (_ref23) {
    var _ref24 = _slicedToArray(_ref23, 1),
      backgroundFilledSuccess = _ref24[0];
    return backgroundFilledSuccess;
  }, ['colors.backgroundFilledSuccess']),
  backgroundFilledWarning: (0, _euiThemeCommon.computed)(function (_ref25) {
    var _ref26 = _slicedToArray(_ref25, 1),
      backgroundFilledWarning = _ref26[0];
    return backgroundFilledWarning;
  }, ['colors.backgroundFilledWarning']),
  backgroundFilledDanger: (0, _euiThemeCommon.computed)(function (_ref27) {
    var _ref28 = _slicedToArray(_ref27, 1),
      backgroundFilledDanger = _ref28[0];
    return backgroundFilledDanger;
  }, ['colors.backgroundFilledDanger']),
  backgroundFilledText: (0, _euiThemeCommon.computed)(function (_ref29) {
    var _ref30 = _slicedToArray(_ref29, 1),
      backgroundFilledText = _ref30[0];
    return backgroundFilledText;
  }, ['colors.backgroundFilledText']),
  backgroundFilledDisabled: (0, _euiThemeCommon.computed)(function (_ref31) {
    var _ref32 = _slicedToArray(_ref31, 1),
      lightShade = _ref32[0];
    return (0, _manipulation.transparentize)(lightShade, 0.15);
  }, ['colors.lightShade']),
  backgroundEmptyPrimaryHover: (0, _euiThemeCommon.computed)(function (_ref33) {
    var _ref34 = _slicedToArray(_ref33, 1),
      primary = _ref34[0];
    return (0, _manipulation.transparentize)(primary, 0.1);
  }, ['colors.primary']),
  backgroundEmptyAccentHover: (0, _euiThemeCommon.computed)(function (_ref35) {
    var _ref36 = _slicedToArray(_ref35, 1),
      accent = _ref36[0];
    return (0, _manipulation.transparentize)(accent, 0.1);
  }, ['colors.accent']),
  backgroundEmptyAccentSecondaryHover: (0, _euiThemeCommon.computed)(function (_ref37) {
    var _ref38 = _slicedToArray(_ref37, 1),
      success = _ref38[0];
    return (0, _manipulation.transparentize)(success, 0.1);
  }, ['colors.success']),
  backgroundEmptySuccessHover: (0, _euiThemeCommon.computed)(function (_ref39) {
    var _ref40 = _slicedToArray(_ref39, 1),
      success = _ref40[0];
    return (0, _manipulation.transparentize)(success, 0.1);
  }, ['colors.success']),
  backgroundEmptyWarningHover: (0, _euiThemeCommon.computed)(function (_ref41) {
    var _ref42 = _slicedToArray(_ref41, 1),
      warning = _ref42[0];
    return (0, _manipulation.transparentize)(warning, 0.1);
  }, ['colors.warning']),
  backgroundEmptyDangerHover: (0, _euiThemeCommon.computed)(function (_ref43) {
    var _ref44 = _slicedToArray(_ref43, 1),
      danger = _ref44[0];
    return (0, _manipulation.transparentize)(danger, 0.1);
  }, ['colors.danger']),
  backgroundEmptyTextHover: (0, _euiThemeCommon.computed)(function (_ref45) {
    var _ref46 = _slicedToArray(_ref45, 1),
      lightShade = _ref46[0];
    return (0, _manipulation.transparentize)(lightShade, 0.2);
  }, ['colors.lightShade']),
  textColorPrimary: (0, _euiThemeCommon.computed)(function (_ref47) {
    var _ref48 = _slicedToArray(_ref47, 1),
      primaryText = _ref48[0];
    return primaryText;
  }, ['colors.primaryText']),
  textColorAccent: (0, _euiThemeCommon.computed)(function (_ref49) {
    var _ref50 = _slicedToArray(_ref49, 1),
      accentText = _ref50[0];
    return accentText;
  }, ['colors.accentText']),
  textColorAccentSecondary: (0, _euiThemeCommon.computed)(function (_ref51) {
    var _ref52 = _slicedToArray(_ref51, 1),
      successText = _ref52[0];
    return successText;
  }, ['colors.successText']),
  textColorSuccess: (0, _euiThemeCommon.computed)(function (_ref53) {
    var _ref54 = _slicedToArray(_ref53, 1),
      successText = _ref54[0];
    return successText;
  }, ['colors.successText']),
  textColorWarning: (0, _euiThemeCommon.computed)(function (_ref55) {
    var _ref56 = _slicedToArray(_ref55, 1),
      warningText = _ref56[0];
    return warningText;
  }, ['colors.warningText']),
  textColorDanger: (0, _euiThemeCommon.computed)(function (_ref57) {
    var _ref58 = _slicedToArray(_ref57, 1),
      dangerText = _ref58[0];
    return dangerText;
  }, ['colors.dangerText']),
  textColorText: (0, _euiThemeCommon.computed)(function (_ref59) {
    var _ref60 = _slicedToArray(_ref59, 1),
      text = _ref60[0];
    return text;
  }, ['colors.text']),
  textColorDisabled: (0, _euiThemeCommon.computed)(function (_ref61) {
    var _ref62 = _slicedToArray(_ref61, 1),
      disabledText = _ref62[0];
    return disabledText;
  }, ['colors.disabledText']),
  textColorFilledPrimary: (0, _euiThemeCommon.computed)(function (_ref63) {
    var _ref64 = _slicedToArray(_ref63, 3),
      primary = _ref64[0],
      ghost = _ref64[1],
      ink = _ref64[2];
    return isDark(primary) ? ghost : ink;
  }, ['colors.primary', 'colors.ghost', 'colors.ink']),
  textColorFilledAccent: (0, _euiThemeCommon.computed)(function (_ref65) {
    var _ref66 = _slicedToArray(_ref65, 3),
      accent = _ref66[0],
      ghost = _ref66[1],
      ink = _ref66[2];
    return isDark(accent) ? ghost : ink;
  }, ['colors.accent', 'colors.ghost', 'colors.ink']),
  textColorFilledAccentSecondary: (0, _euiThemeCommon.computed)(function (_ref67) {
    var _ref68 = _slicedToArray(_ref67, 3),
      success = _ref68[0],
      ghost = _ref68[1],
      ink = _ref68[2];
    var background = (0, _manipulation.tint)(success, 0.3);
    return isDark(background) ? ghost : ink;
  }, ['colors.success', 'colors.ghost', 'colors.ink']),
  textColorFilledSuccess: (0, _euiThemeCommon.computed)(function (_ref69) {
    var _ref70 = _slicedToArray(_ref69, 3),
      success = _ref70[0],
      ghost = _ref70[1],
      ink = _ref70[2];
    var background = (0, _manipulation.tint)(success, 0.3);
    return isDark(background) ? ghost : ink;
  }, ['colors.success', 'colors.ghost', 'colors.ink']),
  textColorFilledWarning: (0, _euiThemeCommon.computed)(function (_ref71) {
    var _ref72 = _slicedToArray(_ref71, 3),
      warning = _ref72[0],
      ghost = _ref72[1],
      ink = _ref72[2];
    return isDark(warning) ? ghost : ink;
  }, ['colors.warning', 'colors.ghost', 'colors.ink']),
  textColorFilledDanger: (0, _euiThemeCommon.computed)(function (_ref73) {
    var _ref74 = _slicedToArray(_ref73, 3),
      danger = _ref74[0],
      ghost = _ref74[1],
      ink = _ref74[2];
    return isDark(danger) ? ghost : ink;
  }, ['colors.danger', 'colors.ghost', 'colors.ink']),
  textColorFilledText: (0, _euiThemeCommon.computed)(function (_ref75) {
    var _ref76 = _slicedToArray(_ref75, 3),
      darkShade = _ref76[0],
      ghost = _ref76[1],
      ink = _ref76[2];
    return isDark(darkShade) ? ghost : ink;
  }, ['colors.darkShade', 'colors.ghost', 'colors.ink']),
  textColorFilledDisabled: (0, _euiThemeCommon.computed)(function (_ref77) {
    var _ref78 = _slicedToArray(_ref77, 1),
      disabledText = _ref78[0];
    return disabledText;
  }, ['colors.disabledText'])
};
var _dark_buttons = _objectSpread(_objectSpread({}, _buttons), {}, {
  backgroundFilledDisabled: (0, _euiThemeCommon.computed)(function (_ref79) {
    var _ref80 = _slicedToArray(_ref79, 1),
      lightShade = _ref80[0];
    return (0, _manipulation.transparentize)(lightShade, 0.15);
  }, ['colors.lightShade']),
  backgroundEmptyTextHover: (0, _euiThemeCommon.computed)(function (_ref81) {
    var _ref82 = _slicedToArray(_ref81, 1),
      lightShade = _ref82[0];
    return (0, _manipulation.transparentize)(lightShade, 0.4);
  }, ['colors.lightShade']),
  textColorFilledAccent: (0, _euiThemeCommon.computed)(function (_ref83) {
    var _ref84 = _slicedToArray(_ref83, 3),
      accent = _ref84[0],
      ghost = _ref84[1],
      ink = _ref84[2];
    return isDark(accent) ? ghost : ink;
  }, ['colors.accent', 'colors.ghost', 'colors.ink']),
  textColorFilledSuccess: (0, _euiThemeCommon.computed)(function (_ref85) {
    var _ref86 = _slicedToArray(_ref85, 3),
      success = _ref86[0],
      ghost = _ref86[1],
      ink = _ref86[2];
    return isDark(success) ? ghost : ink;
  }, ['colors.success', 'colors.ghost', 'colors.ink']),
  textColorFilledText: (0, _euiThemeCommon.computed)(function (_ref87) {
    var _ref88 = _slicedToArray(_ref87, 3),
      text = _ref88[0],
      ghost = _ref88[1],
      ink = _ref88[2];
    return isDark(text) ? ghost : ink;
  }, ['colors.text', 'colors.ghost', 'colors.ink'])
});
var buttons = exports.buttons = {
  LIGHT: _buttons,
  DARK: _dark_buttons
};