"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports._popoverArrowStyles = void 0;
var _react = require("@emotion/react");
var _functions = require("../../global_styling/functions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Arrow clipping/transform/positioning CSS shared between EuiPopover and EuiToolTip
 */
var _popoverArrowStyles = exports._popoverArrowStyles = function _popoverArrowStyles(_ref, arrowSize) {
  var euiTheme = _ref.euiTheme;
  var arrowOffset = (0, _functions.mathWithUnits)(arrowSize, function (x) {
    return x / -2;
  });
  var arrowBorderRadius = (0, _functions.mathWithUnits)(euiTheme.border.radius.small, function (x) {
    return x / 2;
  });
  return {
    _arrowStyles: "\n      position: absolute;\n      ".concat((0, _functions.logicalSizeCSS)(arrowSize), "\n      border-radius: ").concat(arrowBorderRadius, ";\n      /* Use clip-path to ensure that arrows don't overlap into popover content */\n      clip-path: polygon(0 0, 100% 100%, 0 100%);\n      transform-origin: center;\n    "),
    positions: {
      top: /*#__PURE__*/(0, _react.css)((0, _functions.logicalCSS)('margin-top', arrowOffset), " transform:rotate(-45deg);;label:top;"),
      bottom: /*#__PURE__*/(0, _react.css)((0, _functions.logicalCSS)('bottom', 0), " ", (0, _functions.logicalCSS)('margin-bottom', arrowOffset), " transform:rotate(135deg);;label:bottom;"),
      left: /*#__PURE__*/(0, _react.css)((0, _functions.logicalCSS)('margin-left', arrowOffset), " transform:rotate(-135deg);;label:left;"),
      right: /*#__PURE__*/(0, _react.css)((0, _functions.logicalCSS)('right', 0), " ", (0, _functions.logicalCSS)('margin-right', arrowOffset), " transform:rotate(45deg);;label:right;")
    }
  };
};