"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEuiButtonFocusCSS = exports.useEuiButtonColorCSS = exports.euiButtonSizeMap = exports.euiButtonFillColor = exports.euiButtonEmptyColor = exports.euiButtonColor = exports.BUTTON_DISPLAYS = exports.BUTTON_COLORS = void 0;
var _react = require("@emotion/react");
var _euiThemeCommon = require("@elastic/eui-theme-common");
var _services = require("../../services");
var _templateObject;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _taggedTemplateLiteral(e, t) { return t || (t = e.slice(0)), Object.freeze(Object.defineProperties(e, { raw: { value: Object.freeze(t) } })); }
var BUTTON_COLORS = exports.BUTTON_COLORS = ['text', 'accent', 'accentSecondary', 'primary', 'success', 'warning', 'danger'];
var BUTTON_DISPLAYS = exports.BUTTON_DISPLAYS = ['base', 'fill', 'empty'];
/**
 * Creates the `base` version of button styles with proper text contrast.
 * @param euiThemeContext
 * @param color One of the named button colors or 'disabled'
 * @returns Style object `{ backgroundColor, color }`
 */
var euiButtonColor = exports.euiButtonColor = function euiButtonColor(euiThemeContext, color) {
  var euiTheme = euiThemeContext.euiTheme;
  var backgroundTokenName = (0, _euiThemeCommon.getTokenName)('background', color);
  var textTokenName = (0, _euiThemeCommon.getTokenName)('textColor', color);
  var foreground = euiTheme.components.buttons[textTokenName];
  var background = euiTheme.components.buttons[backgroundTokenName];
  return {
    color: background === 'transparent' || color === 'disabled' ? foreground : (0, _services.makeHighContrastColor)(foreground)(background),
    backgroundColor: background
  };
};

/**
 * Creates the `fill` version of buttons styles with proper text contrast.
 * @param euiThemeContext
 * @param color One of the named button colors or 'disabled'
 * @returns Style object `{ backgroundColor, color }`
 */
var euiButtonFillColor = exports.euiButtonFillColor = function euiButtonFillColor(euiThemeContext, color) {
  var euiTheme = euiThemeContext.euiTheme;
  var backgroundTokenName = (0, _euiThemeCommon.getTokenName)('backgroundFilled', color);
  var textColorTokenName = (0, _euiThemeCommon.getTokenName)('textColorFilled', color);
  var foreground = euiTheme.components.buttons[textColorTokenName];
  var background = euiTheme.components.buttons[backgroundTokenName];
  return {
    color: foreground,
    backgroundColor: background
  };
};

/**
 * Creates the `empty` version of button styles using the text-variant and adding interactive styles.
 * @param euiThemeContext
 * @param color One of the named button colors or 'disabled'
 * @returns Style object `{ backgroundColor, color }` where `background` is typically used for interactive states
 */
var euiButtonEmptyColor = exports.euiButtonEmptyColor = function euiButtonEmptyColor(euiThemeContext, color) {
  var foreground;
  var background;
  switch (color) {
    case 'disabled':
      foreground = euiButtonColor(euiThemeContext, color).color;
      background = 'transparent';
      break;
    default:
      {
        var backgroundToken = (0, _euiThemeCommon.getTokenName)('backgroundEmpty', color, 'hover');
        foreground = euiButtonColor(euiThemeContext, color).color;
        background = euiThemeContext.euiTheme.components.buttons[backgroundToken];
        break;
      }
  }
  return {
    color: foreground,
    backgroundColor: background
  };
};

/**
 * Given the button display type, returns the Emotion based color keys.
 * @param options Button display type
 * @returns An object of `_EuiButtonColor` keys including `disabled`
 */
var useEuiButtonColorCSS = exports.useEuiButtonColorCSS = function useEuiButtonColorCSS() {
  var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var _options$display = options.display,
    display = _options$display === void 0 ? 'base' : _options$display;
  var colorsDisplaysMap = (0, _services.useEuiMemoizedStyles)(euiButtonDisplaysColors);
  return colorsDisplaysMap[display];
};
var euiButtonDisplaysColors = function euiButtonDisplaysColors(euiThemeContext) {
  var COLORS = [].concat(BUTTON_COLORS, ['disabled']);
  var displaysColorsMap = {};
  BUTTON_DISPLAYS.forEach(function (display) {
    displaysColorsMap[display] = {};
    COLORS.forEach(function (color) {
      switch (display) {
        case 'base':
          displaysColorsMap[display][color] = /*#__PURE__*/(0, _react.css)(euiButtonColor(euiThemeContext, color), ";;label:displaysColorsMap-display-color;");
          break;
        case 'fill':
          displaysColorsMap[display][color] = /*#__PURE__*/(0, _react.css)(euiButtonFillColor(euiThemeContext, color), "outline-color:", euiThemeContext.colorMode === 'DARK' && color === 'text' ? 'currentColor' : euiThemeContext.euiTheme.colors.fullShade, ";;label:displaysColorsMap-display-color;");
          break;
        case 'empty':
          displaysColorsMap[display][color] = /*#__PURE__*/(0, _react.css)("color:", euiButtonEmptyColor(euiThemeContext, color).color, ";&:focus,&:active{background-color:", euiButtonEmptyColor(euiThemeContext, color).backgroundColor, ";};label:displaysColorsMap-display-color;");
          break;
      }

      // Tweak auto-generated Emotion label/className output
      var emotionOutput = displaysColorsMap[display][color];
      emotionOutput.styles = emotionOutput.styles.replace('label:displaysColorsMap-display-color;', "label:".concat(display, "-").concat(color, ";"));
    });
  });
  return displaysColorsMap;
};

/**
 * Creates the translate animation when button is in focus.
 * @returns string
 */
var useEuiButtonFocusCSS = exports.useEuiButtonFocusCSS = function useEuiButtonFocusCSS() {
  return (0, _services.useEuiMemoizedStyles)(euiButtonFocusCSS);
};
var euiButtonFocusAnimation = (0, _react.keyframes)(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n  50% {\n    transform: translateY(1px);\n  }\n"])));
var euiButtonFocusCSS = function euiButtonFocusCSS(_ref) {
  var euiTheme = _ref.euiTheme;
  var focusCSS = /*#__PURE__*/(0, _react.css)(_euiThemeCommon.euiCanAnimate, "{transition:transform ", euiTheme.animation.normal, " ease-in-out,background-color ", euiTheme.animation.normal, " ease-in-out;&:hover:not(:disabled){transform:translateY(-1px);}&:focus{animation:", euiButtonFocusAnimation, " ", euiTheme.animation.normal, " ", euiTheme.animation.bounce, ";}&:active:not(:disabled){transform:translateY(1px);}};label:focusCSS;");
  // Remove the auto-generated label.
  // We could typically avoid a label by using a plain string `` instead of css``,
  // but we need css`` for keyframes`` to work for the focus animation
  focusCSS.styles = focusCSS.styles.replace('label:focusCSS;', '');
  return focusCSS;
};

/**
 * Map of `size` props to various sizings/scales
 * that should remain consistent across all buttons
 */
var euiButtonSizeMap = exports.euiButtonSizeMap = function euiButtonSizeMap(_ref2) {
  var euiTheme = _ref2.euiTheme;
  return {
    xs: {
      height: euiTheme.size.l,
      radius: euiTheme.border.radius.small,
      fontScale: 'xs'
    },
    s: {
      height: euiTheme.size.xl,
      radius: euiTheme.border.radius.small,
      fontScale: 's'
    },
    m: {
      height: euiTheme.size.xxl,
      radius: euiTheme.border.radius.medium,
      fontScale: 's'
    }
  };
};