"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TOAST_FADE_OUT_MS = exports.SIDES = exports.EuiGlobalToastList = exports.CLEAR_ALL_TOASTS_THRESHOLD_DEFAULT = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _common = require("../common");
var _services = require("../../services");
var _time = require("../../services/time");
var _global_toast_list_item = require("./global_toast_list_item");
var _toast = require("./toast");
var _global_toast_list = require("./global_toast_list.styles");
var _button = require("../button");
var _i18n = require("../i18n");
var _react2 = require("@emotion/react");
var _excluded = ["className", "toasts", "dismissToast", "toastLifeTimeMs", "onClearAllToasts", "side", "showClearAllButtonAt"],
  _excluded2 = ["text", "toastLifeTimeMs"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var sideToClassNameMap = {
  left: 'euiGlobalToastList--left',
  right: 'euiGlobalToastList--right'
};
var SIDES = exports.SIDES = (0, _common.keysOf)(sideToClassNameMap);
var TOAST_FADE_OUT_MS = exports.TOAST_FADE_OUT_MS = 250;
var CLEAR_ALL_TOASTS_THRESHOLD_DEFAULT = exports.CLEAR_ALL_TOASTS_THRESHOLD_DEFAULT = 3;
var EuiGlobalToastList = exports.EuiGlobalToastList = function EuiGlobalToastList(_ref) {
  var className = _ref.className,
    _ref$toasts = _ref.toasts,
    toasts = _ref$toasts === void 0 ? [] : _ref$toasts,
    dismissToastProp = _ref.dismissToast,
    toastLifeTimeMs = _ref.toastLifeTimeMs,
    onClearAllToasts = _ref.onClearAllToasts,
    _ref$side = _ref.side,
    side = _ref$side === void 0 ? 'right' : _ref$side,
    _ref$showClearAllButt = _ref.showClearAllButtonAt,
    showClearAllButtonAt = _ref$showClearAllButt === void 0 ? CLEAR_ALL_TOASTS_THRESHOLD_DEFAULT : _ref$showClearAllButt,
    rest = _objectWithoutProperties(_ref, _excluded);
  var _useState = (0, _react.useState)({}),
    _useState2 = _slicedToArray(_useState, 2),
    toastIdToDismissedMap = _useState2[0],
    setToastIdToDismissedMap = _useState2[1];
  var _useState3 = (0, _react.useState)(),
    _useState4 = _slicedToArray(_useState3, 2),
    toastToDismiss = _useState4[0],
    setToastToDismiss = _useState4[1];
  var prevToasts = (0, _react.useRef)([]);
  var dismissTimeoutIds = (0, _react.useRef)([]);
  var toastIdToTimerMap = (0, _react.useRef)({});
  var isScrollingToBottom = (0, _react.useRef)(false);
  var isScrolledToBottom = (0, _react.useRef)(true);
  var isUserInteracting = (0, _react.useRef)(false);

  // See [Return Value](https://developer.mozilla.org/en-US/docs/Web/API/Window/requestAnimationFrame#Return_value)
  // for information on initial value of 0
  var isScrollingAnimationFrame = (0, _react.useRef)(0);
  var startScrollingAnimationFrame = (0, _react.useRef)(0);
  var listElement = (0, _react.useRef)(null);
  var styles = (0, _services.useEuiMemoizedStyles)(_global_toast_list.euiGlobalToastListStyles);
  var cssStyles = [styles.euiGlobalToastList, styles[side]];
  var startScrollingToBottom = (0, _react.useCallback)(function () {
    isScrollingToBottom.current = true;
    var scrollToBottom = function scrollToBottom() {
      // Although we cancel the requestAnimationFrame in componentWillUnmount,
      // it's possible for this.listElement to become null in the meantime
      if (!listElement.current) {
        return;
      }
      var position = listElement.current.scrollTop;
      var destination = listElement.current.scrollHeight - listElement.current.clientHeight;
      var distanceToDestination = destination - position;
      if (distanceToDestination < 5) {
        listElement.current.scrollTop = destination;
        isScrollingToBottom.current = false;
        isScrolledToBottom.current = true;
        return;
      }
      listElement.current.scrollTop = position + distanceToDestination * 0.25;
      if (isScrollingToBottom) {
        isScrollingAnimationFrame.current = window.requestAnimationFrame(scrollToBottom);
      }
    };
    startScrollingAnimationFrame.current = window.requestAnimationFrame(scrollToBottom);
  }, []);
  var onMouseEnter = (0, _react.useCallback)(function () {
    // Stop scrolling to bottom if we're in mid-scroll, because the user wants to interact with
    // the list.
    isScrollingToBottom.current = false;
    isUserInteracting.current = true;

    // Don't let toasts dismiss themselves while the user is interacting with them.
    for (var _toastId in toastIdToTimerMap.current) {
      if (toastIdToTimerMap.current.hasOwnProperty(_toastId)) {
        var timer = toastIdToTimerMap.current[_toastId];
        timer.pause();
      }
    }
  }, []);
  var onMouseLeave = (0, _react.useCallback)(function () {
    isUserInteracting.current = false;
    for (var _toastId2 in toastIdToTimerMap.current) {
      if (toastIdToTimerMap.current.hasOwnProperty(_toastId2)) {
        var timer = toastIdToTimerMap.current[_toastId2];
        timer.resume();
      }
    }
  }, []);
  var onScroll = (0, _react.useCallback)(function () {
    // Given that this method also gets invoked by the synthetic scroll that happens when a new toast gets added,
    // we want to evaluate if the scroll bottom has been reached only when the user is interacting with the toast,
    // this way we always retain the scroll position the user has set despite adding in new toasts.
    // User interaction is determined through the handler registered for mouseEnter and mouseLeave events.
    if (listElement.current && isUserInteracting.current) {
      isScrolledToBottom.current = listElement.current.scrollHeight - listElement.current.scrollTop === listElement.current.clientHeight;
    }
  }, []);
  var dismissToast = (0, _react.useCallback)(function (toast) {
    // Remove the toast after it's done fading out.
    dismissTimeoutIds.current.push(window.setTimeout(function () {
      setToastToDismiss(toast);
    }, TOAST_FADE_OUT_MS));
    setToastIdToDismissedMap(function (prev) {
      return _objectSpread(_objectSpread({}, prev), {}, _defineProperty({}, toast.id, true));
    });
  }, []);
  var scheduleToastForDismissal = (0, _react.useCallback)(function (toast) {
    // Start fading the toast out once its lifetime elapses.
    toastIdToTimerMap.current[toast.id] = new _time.Timer(function () {
      return dismissToast(toast);
    }, toast.toastLifeTimeMs != null ? toast.toastLifeTimeMs : toastLifeTimeMs);
  }, [dismissToast, toastLifeTimeMs]);
  var scheduleAllToastsForDismissal = (0, _react.useCallback)(function () {
    toasts.forEach(function (toast) {
      if (!toastIdToTimerMap.current[toast.id]) {
        scheduleToastForDismissal(toast);
      }
    });
  }, [scheduleToastForDismissal, toasts]);

  // componentDidMount
  (0, _react.useEffect)(function () {
    var listenerEl = listElement.current;
    if (listenerEl) {
      listenerEl.addEventListener('scroll', onScroll);
      listenerEl.addEventListener('mouseenter', onMouseEnter);
      listenerEl.addEventListener('mouseleave', onMouseLeave);
    }

    // componentWillUnmount
    return function () {
      if (listenerEl) {
        listenerEl.removeEventListener('scroll', onScroll);
        listenerEl.removeEventListener('mouseenter', onMouseEnter);
        listenerEl.removeEventListener('mouseleave', onMouseLeave);
      }
      if (isScrollingAnimationFrame.current !== 0) {
        window.cancelAnimationFrame(isScrollingAnimationFrame.current);
      }
      if (startScrollingAnimationFrame.current !== 0) {
        window.cancelAnimationFrame(startScrollingAnimationFrame.current);
      }
      dismissTimeoutIds.current.forEach(clearTimeout); // eslint-disable-line react-hooks/exhaustive-deps
      for (var _toastId3 in toastIdToTimerMap.current) {
        if (toastIdToTimerMap.current.hasOwnProperty(_toastId3)) {
          var timer = toastIdToTimerMap.current[_toastId3]; // eslint-disable-line react-hooks/exhaustive-deps
          timer.clear();
        }
      }
    };
  }, [onMouseEnter, onMouseLeave, onScroll]);

  // componentDidUpdate
  (0, _react.useEffect)(function () {
    scheduleAllToastsForDismissal();
    if (!isUserInteracting.current) {
      // If the user has scrolled up the toast list then we don't want to annoy them by scrolling
      // all the way back to the bottom.
      if (isScrolledToBottom.current) {
        if (prevToasts.current.length < toasts.length) {
          startScrollingToBottom();
        }
      }
    }
    prevToasts.current = toasts;
  }, [toasts, scheduleAllToastsForDismissal, startScrollingToBottom]);

  // Toast dismissal side effect
  // Ensure the callback has correct state by not enclosing it in `setTimeout`
  (0, _react.useEffect)(function () {
    var toast = toastToDismiss;
    // Because this is triggered by a setTimeout, and because React does not guarantee when
    // state updates happen, it is possible to double-dismiss a toast
    // including by double-clicking the "x" button on the toast
    // so, first check to make sure we haven't already dismissed this toast
    if (toast && toastIdToTimerMap.current.hasOwnProperty(toast.id)) {
      dismissToastProp(toast);
      toastIdToTimerMap.current[toast.id].clear();
      delete toastIdToTimerMap.current[toast.id];
      setToastIdToDismissedMap(function (prev) {
        var toastIdToDismissedMap = _objectSpread({}, prev);
        delete toastIdToDismissedMap[toast.id];
        return toastIdToDismissedMap;
      });
    }
  }, [toastToDismiss, dismissToastProp]);
  var renderedToasts = (0, _react.useMemo)(function () {
    return toasts.map(function (toast) {
      var text = toast.text,
        toastLifeTimeMs = toast.toastLifeTimeMs,
        rest = _objectWithoutProperties(toast, _excluded2);
      var onClose = function onClose() {
        return dismissToast(toast);
      };
      return (0, _react2.jsx)(_global_toast_list_item.EuiGlobalToastListItem, {
        key: toast.id,
        isDismissed: toastIdToDismissedMap[toast.id]
      }, (0, _react2.jsx)(_toast.EuiToast, _extends({
        onClose: onClose,
        onFocus: onMouseEnter,
        onBlur: onMouseLeave
      }, rest), text));
    });
  }, [toasts, toastIdToDismissedMap, dismissToast, onMouseEnter, onMouseLeave]);
  var clearAllButton = (0, _react.useMemo)(function () {
    if (toasts.length && showClearAllButtonAt && toasts.length >= showClearAllButtonAt) {
      return (0, _react2.jsx)(_i18n.EuiI18n, {
        key: "euiClearAllToasts",
        tokens: ['euiGlobalToastList.clearAllToastsButtonAriaLabel', 'euiGlobalToastList.clearAllToastsButtonDisplayText'],
        defaults: ['Clear all toast notifications', 'Clear all']
      }, function (_ref2) {
        var _ref3 = _slicedToArray(_ref2, 2),
          clearAllToastsButtonAriaLabel = _ref3[0],
          clearAllToastsButtonDisplayText = _ref3[1];
        return (0, _react2.jsx)(_global_toast_list_item.EuiGlobalToastListItem, {
          isDismissed: false
        }, (0, _react2.jsx)(_button.EuiButton, {
          fill: true,
          color: "text",
          onClick: function onClick() {
            toasts.forEach(function (toast) {
              return dismissToastProp(toast);
            });
            onClearAllToasts === null || onClearAllToasts === void 0 || onClearAllToasts();
          },
          css: styles.euiGlobalToastListDismissButton,
          "aria-label": clearAllToastsButtonAriaLabel,
          "data-test-subj": "euiClearAllToastsButton"
        }, clearAllToastsButtonDisplayText));
      });
    }
  }, [showClearAllButtonAt, onClearAllToasts, toasts, dismissToastProp, styles]);
  var classes = (0, _classnames.default)('euiGlobalToastList', className);
  return (0, _react2.jsx)("div", _extends({
    "aria-live": "polite",
    role: "log",
    ref: listElement,
    css: cssStyles,
    className: classes
  }, rest), renderedToasts, clearAllButton);
};
EuiGlobalToastList.propTypes = {
  toasts: _propTypes.default.arrayOf(_propTypes.default.shape({
    id: _propTypes.default.string.isRequired,
    text: _propTypes.default.node,
    toastLifeTimeMs: _propTypes.default.number,
    title: _propTypes.default.node,
    color: _propTypes.default.any,
    iconType: _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "agentApp", "aggregate", "analyzeEvent", "annotation", "anomalyChart", "anomalySwimLane", "apmApp", "apmTrace", "appSearchApp", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "arrowStart", "arrowEnd", "article", "asterisk", "at", "auditbeatApp", "beaker", "bell", "bellSlash", "beta", "bolt", "boxesHorizontal", "boxesVertical", "branch", "branchUser", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "casesApp", "changePointDetection", "check", "checkInCircleFilled", "cheer", "classificationJob", "clickLeft", "clickRight", "clock", "clockCounter", "cloudDrizzle", "cloudStormy", "cloudSunny", "cluster", "codeApp", "color", "compute", "console", "consoleApp", "container", "continuityAbove", "continuityAboveBelow", "continuityBelow", "continuityWithin", "contrast", "contrastHigh", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crossInCircle", "crosshairs", "currency", "cut", "dashboardApp", "dataVisualizer", "database", "desktop", "devToolsApp", "diff", "discoverApp", "discuss", "document", "documentEdit", "documentation", "documents", "dot", "dotInCircle", "doubleArrowLeft", "doubleArrowRight", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorChecklist", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignLeft", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "endpoint", "eql", "eraser", "error", "errorFilled", "esqlVis", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "fieldStatistics", "filebeatApp", "filter", "filterExclude", "filterIgnore", "filterInclude", "filterInCircle", "flag", "fleetApp", "fold", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "frameNext", "framePrevious", "fullScreen", "fullScreenExit", "function", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "grabOmnidirectional", "gradient", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "index", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexRuntime", "indexSettings", "indexTemporary", "infinity", "inputOutput", "inspect", "invert", "ip", "key", "keyboard", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "kubernetesNode", "kubernetesPod", "launch", "layers", "lensApp", "lettering", "lineDashed", "lineDotted", "lineSolid", "link", "list", "listAdd", "lock", "lockOpen", "logPatternAnalysis", "logRateAnalysis", "logoAWS", "logoAWSMono", "logoAerospike", "logoApache", "logoAppSearch", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticStack", "logoElasticsearch", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoVulnerabilityManagement", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logsApp", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithExclamation", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuDown", "menuLeft", "menuRight", "menuUp", "merge", "metricbeatApp", "metricsApp", "minimize", "minus", "minusInCircle", "minusInCircleFilled", "minusInSquare", "mobile", "monitoringApp", "moon", "move", "namespace", "nested", "newChat", "node", "notebookApp", "number", "offline", "online", "outlierDetectionJob", "package", "packetbeatApp", "pageSelect", "pagesSelect", "palette", "paperClip", "partial", "pause", "payment", "pencil", "percent", "pin", "pinFilled", "pipeBreaks", "pipelineApp", "pipeNoBreaks", "pivot", "play", "playFilled", "plus", "plusInCircle", "plusInCircleFilled", "plusInSquare", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "regressionJob", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "sessionViewer", "shard", "share", "singleMetricViewer", "snowflake", "sortAscending", "sortDescending", "sortDown", "sortLeft", "sortRight", "sortUp", "sortable", "spaces", "spacesApp", "sparkles", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "sun", "swatchInput", "symlink", "tableDensityCompact", "tableDensityExpanded", "tableDensityNormal", "tableOfContents", "tag", "tear", "temperature", "timeline", "timelineWithArrow", "timelionApp", "timeRefresh", "timeslider", "training", "transitionLeftIn", "transitionLeftOut", "transitionTopIn", "transitionTopOut", "trash", "unfold", "unlink", "upgradeAssistantApp", "uptimeApp", "user", "userAvatar", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visVega", "visVisualBuilder", "visualizeApp", "vulnerabilityManagementApp", "warning", "warningFilled", "alert", "watchesApp", "wordWrap", "wordWrapDisabled", "workplaceSearchApp", "wrench", "tokenAlias", "tokenAnnotation", "tokenArray", "tokenBinary", "tokenBoolean", "tokenClass", "tokenCompletionSuggester", "tokenConstant", "tokenDate", "tokenDimension", "tokenElement", "tokenEnum", "tokenEnumMember", "tokenEvent", "tokenException", "tokenField", "tokenFile", "tokenFlattened", "tokenFunction", "tokenGeo", "tokenHistogram", "tokenInterface", "tokenIP", "tokenJoin", "tokenKey", "tokenKeyword", "tokenMethod", "tokenMetricCounter", "tokenMetricGauge", "tokenModule", "tokenNamespace", "tokenNested", "tokenNull", "tokenNumber", "tokenObject", "tokenOperator", "tokenPackage", "tokenParameter", "tokenPercolator", "tokenProperty", "tokenRange", "tokenRankFeature", "tokenRankFeatures", "tokenRepo", "tokenSearchType", "tokenSemanticText", "tokenShape", "tokenString", "tokenStruct", "tokenSymbol", "tokenTag", "tokenText", "tokenTokenCount", "tokenVariable", "tokenVectorDense", "tokenDenseVector", "tokenVectorSparse"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]),
    onClose: _propTypes.default.func,
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }).isRequired),
  dismissToast: _propTypes.default.func.isRequired,
  toastLifeTimeMs: _propTypes.default.number.isRequired,
  /**
     * Determines which side of the browser window the toasts should appear
     */
  side: _propTypes.default.oneOf(["right", "left"]),
  /**
     * At this threshold, a "Clear all" button will display at the bottom of the toast list
     * that allows users to dismiss all toasts in a single click.
     *
     * Defaults to `3`. Set to `0` to disable the button entirely.
     */
  showClearAllButtonAt: _propTypes.default.number,
  /**
     * Optional callback that fires when a user clicks the "Clear all" button.
     */
  onClearAllToasts: _propTypes.default.func,
  /**
     * Defaults to the [log role](https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Roles/log_role).
     *
     * The [alert role](https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Roles/alert_role)
     * can be considered only if *all* toasts in this list will require immediate user attention.
     * Several alerts at once, and unnecessary alerts, will a create bad screen reader user experience.
     *
     * @default log
     */
  role: _propTypes.default.any,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};