"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiSkeletonRectangleStyles = void 0;
var _react = require("@emotion/react");
var _utils = require("./utils");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "ubzie1-none",
  styles: "border-radius:0;label:none;"
} : {
  name: "ubzie1-none",
  styles: "border-radius:0;label:none;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiSkeletonRectangleStyles = exports.euiSkeletonRectangleStyles = function euiSkeletonRectangleStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiSkeletonRectangle: /*#__PURE__*/(0, _react.css)("display:block;", (0, _utils.euiSkeletonGradientAnimation)(euiThemeContext, {
      slideSize: '-75%',
      gradientSize: '350%'
    }), ";;label:euiSkeletonRectangle;"),
    // Border radius
    s: /*#__PURE__*/(0, _react.css)("border-radius:", euiTheme.border.radius.small, ";;label:s;"),
    m: /*#__PURE__*/(0, _react.css)("border-radius:", euiTheme.border.radius.medium, ";;label:m;"),
    none: _ref
  };
};