"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiPopoverPanelContext = exports.EuiPopoverPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _panel = require("../../panel/panel");
var _popover_panel = require("./_popover_panel.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "isOpen", "isAttached", "hasDragDrop", "position"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var DEFAULT_PANEL_PADDING_SIZE = 'l';
var EuiPopoverPanelContext = exports.EuiPopoverPanelContext = /*#__PURE__*/(0, _react.createContext)({
  paddingSize: DEFAULT_PANEL_PADDING_SIZE
});
/**
 * *INTERNAL ONLY*
 * Purely for re-use of styling
 */
var EuiPopoverPanel = exports.EuiPopoverPanel = function EuiPopoverPanel(_ref) {
  var children = _ref.children,
    className = _ref.className,
    isOpen = _ref.isOpen,
    isAttached = _ref.isAttached,
    hasDragDrop = _ref.hasDragDrop,
    position = _ref.position,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = (0, _classnames.default)('euiPopover__panel', className);
  var euiThemeContext = (0, _services.useEuiTheme)();
  var cssStyles = (0, _react.useMemo)(function () {
    var styles = (0, _popover_panel.euiPopoverPanelStyles)(euiThemeContext);
    var colorMode = euiThemeContext.colorMode.toLowerCase();
    var sharedStyles = [styles.euiPopover__panel, styles[colorMode], isOpen && styles.isOpen];
    if (hasDragDrop) {
      return [].concat(sharedStyles, [styles.hasDragDrop.hasDragDrop, position && styles.hasDragDrop[position]]);
    }
    if (isAttached) {
      return [].concat(sharedStyles, [styles.isAttached.isAttached, position && styles.isAttached[position]]);
    }
    return [].concat(sharedStyles, [styles.hasTransform.hasTransform, isOpen && position && styles.hasTransform[position]]);
  }, [euiThemeContext, isOpen, position, isAttached, hasDragDrop]);
  return (0, _react2.jsx)(EuiPopoverPanelContext.Provider, {
    value: {
      paddingSize: rest.paddingSize || DEFAULT_PANEL_PADDING_SIZE
    }
  }, (0, _react2.jsx)(_panel.EuiPanel, _extends({
    className: classes,
    css: cssStyles,
    "data-popover-panel": true,
    "data-popover-open": isOpen || undefined
  }, rest), children));
};
EuiPopoverPanel.propTypes = {
  isOpen: _propTypes.default.bool,
  isAttached: _propTypes.default.bool,
  position: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.oneOf([null])]),
  hasDragDrop: _propTypes.default.bool
};